<div class="dashboard-list-box margin-top-50 userProfileSection @if( $user->hasFullName() ) profileSectionFilled @else profileSectionEmpty @endif">
    <h4 class="gray">Persönliche Daten</h4>

    <div class="padding-top-30 padding-bottom-30">
        <div class="profile-form userProfileStatic">
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Anrede</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="salutation" readonly value="{{ $user->salutation }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Vorname</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="firstname" readonly value="{{ $user->firstname }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Nachname</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="surname" readonly value="{{ $user->surname }}">
                </div>
            </div>
        </div>

        <div class="profile-form userProfileEditable">
            <form action="{{ route('api.change-personal') }}">
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileSalutation">Anrede</label>
                    </div>
                    <div class="col-xs-8">
                        <select class="custom-select userProfileInput" id="userProfileSalutation" name="salutation">
                            <option disabled>Bitte wählen</option>
                            <option value="Herr" @if('Herr' === $user->salutation) selected @endif>Herr</option>
                            <option value="Frau" @if('Frau' === $user->salutation) selected @endif>Frau</option>
                        </select>
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="salutation"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileName">Vorname</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileName" name="firstname" placeholder="Vorname" value="{{ $user->firstname }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="firstname"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileSurname">Nachname</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileSurname" name="surname" placeholder="Nachname" value="{{ $user->surname }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="surname"></p>
                </div>
            </form>
        </div>

        <div class="text-center userProfileStatic">
            <button class="button userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</button>
        </div>

        <div class="text-center userProfileEditable">
            <button class="button userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</button>
            <button class="button button-cancel userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</button>
        </div>
    </div>

    <div class="userProfileOverlay">
        <span><i class="fa fa-spinner animate-spin"></i></span>
    </div>
</div>