<a name="email"></a>
<div class="dashboard-list-box margin-top-50 userProfileSection @if($user->email_verified) profileSectionFilled @else profileSectionEmpty @endif">
    <h4 class="gray">Kontaktdaten</h4>

    <div class="padding-top-30 padding-bottom-30">
        <div class="profile-form userProfileStatic">
            <div class="col-xs-12">
                @if(!$user->email_verified)
                    <div class="notification warning margin-bottom-40 text-center">
                        <p>Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                        @if($user->email_temp)
                            <p>Aktuelle login E-Mail: <strong>{{ $user->email }}</strong></p>
                        @endif
                        <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" id="emailVerificationSend">hier klicken</a>.</p>
                    </div>
                @endif
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Telefon</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="phone" readonly value="{{ $user->phone }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>E-Mail</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="email" readonly value="{{ $user->email_temp ? $user->email_temp : $user->email }}">
                </div>
            </div>
        </div>

        <div class="profile-form userProfileEditable">
            <form action="{{ route('api.change-contacts') }}" data-reload="true">
                <div class="col-xs-12">
                    <div class="notification error">
                        <p>Nach Änderung gilt die neue E-Mail für die Anmeldung.</p>
                    </div>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfilePhone">Telefon</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfilePhone" name="phone" placeholder="Telefon" value="{{ $user->phone }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="phone"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileEmail">E-Mail</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileEmail" name="email" placeholder="E-Mail" value="{{ $user->email_temp ? $user->email_temp : $user->email }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="email"></p>
                </div>
            </form>
        </div>

        <div class="text-center userProfileStatic">
            <button class="button userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</button>
        </div>

        <div class="text-center userProfileEditable">
            <button class="button userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</button>
            <button class="button button-cancel userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</button>
        </div>
    </div>

    <div class="userProfileOverlay">
        <span><i class="fa fa-spinner animate-spin"></i></span>
    </div>
</div>