<div class="dashboard-list-box margin-top-50 userProfileSection @if( $user->hasAddress() ) profileSectionFilled @else profileSectionEmpty @endif">
    <h4 class="gray">Allgemeine Daten</h4>

    <div class="padding-top-30 padding-bottom-30">
        <div class="profile-form userProfileStatic">
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Straße</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="street" readonly value="{{ $user->account->street }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Hausnummer</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="housenumber" readonly value="{{ $user->account->housenumber }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>PLZ</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="zip" readonly value="{{ $user->account->zip }}">
                </div>
            </div>
            <div class="col-xs-12">
                <div class="col-xs-4 text-right">
                    <label>Ort</label>
                </div>
                <div class="col-xs-8">
                    <input type="text" data-binded="city" readonly value="{{ $user->account->city }}">
                </div>
            </div>
        </div>

        <div class="profile-form userProfileEditable">
            <form action="{{ route('api.change-address') }}">
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileStreet">Straße</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileStreet" name="street" placeholder="Straße" value="{{ $user->account->street }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="street"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileHousenumber">Hausnummer</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileHousenumber" name="housenumber" placeholder="Hausnummer" value="{{ $user->account->housenumber }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="housenumber"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileZIP">PLZ</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileZIP" name="zip" placeholder="PLZ" value="{{ $user->account->zip }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="zip"></p>
                </div>
                <div class="col-xs-12">
                    <div class="col-xs-4 text-right">
                        <label for="userProfileCity">Ort</label>
                    </div>
                    <div class="col-xs-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileCity" name="city" placeholder="Ort" value="{{ $user->account->city }}">
                    </div>
                    <p class="userProfileError text-danger text-center" data-input="city"></p>
                </div>
            </form>
        </div>

        <div class="text-center userProfileStatic">
            <button class="button userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</button>
        </div>

        <div class="text-center userProfileEditable">
            <button class="button userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</button>
            <button class="button button-cancel userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</button>
        </div>
    </div>

    <div class="userProfileOverlay">
        <span><i class="fa fa-spinner animate-spin"></i></span>
    </div>
</div>