<tr class="payoutItem" data-id="{{ $transaction->id }}" data-amount="{{ $transaction->amount }}">
    <td class="align-middle payoutItemCoupon">
        <span class="text-monospace">{{ $transaction->coupon->present()->code }}</span>
        <div class="btn btn-outline-secondary btn-round showCoupon"
             data-coupon-id="{{ $transaction->coupon->id }}"
             @if ( \App\Coupon::STATUS_PAID === $transaction->coupon->status && Auth::id() === $transaction->coupon->consumer->id )
             data-toggle="tooltip" data-placement="top" title="Müssen bewertet werden"
             @endif
        >
            @if ( \App\Coupon::STATUS_PAID === $transaction->coupon->status && Auth::id() === $transaction->coupon->consumer->id )
                <i class="fas fa-exclamation"></i>
            @else
                <i class="fas fa-question"></i>
            @endif
        </div>
    </td>
    <td class="align-middle payoutItemAmount">{{ Format::currency($transaction->amount) }}</td>
    <td class="align-middle">
        <div class="custom-control custom-checkbox">
            @if ( \App\Coupon::STATUS_PAID === $transaction->coupon->status && Auth::id() === $transaction->coupon->consumer->id )
                <input type="checkbox" class="custom-control-input payoutCheckbox rateCoupon" data-coupon-id="{{ $transaction->coupon->id }}" id="payoutCheckbox{{ $transaction->id }}" data-id="{{ $transaction->id }}">
                <label class="custom-control-label" for="payoutCheckbox{{ $transaction->id }}" data-toggle="tooltip" data-placement="top" title="Müssen bewertet werden">&nbsp;</label>
            @else
                <input type="checkbox" class="custom-control-input payoutCheckbox" id="payoutCheckbox{{ $transaction->id }}" data-id="{{ $transaction->id }}">
                <label class="custom-control-label" for="payoutCheckbox{{ $transaction->id }}">&nbsp;</label>
            @endif
        </div>
    </td>
</tr>