<tr>
    <td class="align-middle">
        @include('redesign.front.pieces.tables.gift_cell', ['gift' => $usersGift->gift])
    </td>
    <td class="align-middle d-none d-md-table-cell">
        <span class="text-monospace">{{ $usersGift->coupon->present()->code }}</span>
        <div class="btn btn-outline-secondary btn-round showCoupon" data-coupon-id="{{ $usersGift->coupon->id }}">
            <i class="fas fa-question"></i>
        </div>
    </td>
    <td class="align-middle d-none d-xl-table-cell">{{ $usersGift->present()->address }}</td>
    <td class="align-middle d-none d-md-table-cell">{{ $usersGift->present()->status }}</td>
    <td class="align-middle d-none d-lg-table-cell">
        @if ( $usersGift->isEditableByOwner() )
            <div class="btn btn-primary setGiftAddress"
                 data-gift-id="{{ $usersGift->id }}"
                 data-zip="{{ $usersGift->address_plz }}"
                 data-city="{{ $usersGift->address_ort }}"
                 data-street="{{ $usersGift->address_str }}"
                 data-house="{{ $usersGift->address_num }}"
                 data-comment="{{ $usersGift->address_add }}"
            >
                <i class="fa fa-edit"></i> Adresse einstellen
            </div>
        @endif
        @if ( $usersGift->isSent() )
            <div data-gift-id="{{ $usersGift->id }}" class="btn btn-success setGiftReceived">
                <i class="far fa-check-circle"></i> Als erhalten markieren
            </div>
        @endif
    </td>
    <td class="align-middle d-md-none">{{ $usersGift->present()->statusBadge }}</td>
    <td class="align-middle d-xl-none">
        <a class="btn btn-outline-primary btn-round" data-toggle="collapse" href="#details{{ $usersGift->id }}" role="button" aria-expanded="false" aria-controls="details{{ $usersGift->id }}">
            <i class="fas fa-file-invoice"></i>
        </a>
        <span class="text-primary show-more-label" data-toggle="collapse" href="#details{{ $usersGift->id }}" aria-expanded="false" aria-controls="details{{ $usersGift->id }}">Mehr</span>
    </td>
</tr>

<tr>
    <td colspan="9" class="d-xl-none p-0">
        <div class="shadow pt-2 pb-2 collapse" id="details{{ $usersGift->id }}" class="transaction-details">
            <div class="row pt-2">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Adresse</strong>
                    {{ $usersGift->present()->address }}
                </div>
            </div>
            <div class="row pt-2 d-md-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">RECO.BON</strong>
                    <span class="text-monospace">{{ $usersGift->coupon->present()->code }}</span>
                    <div class="btn btn-outline-secondary btn-round showCoupon" data-coupon-id="{{ $usersGift->coupon->id }}">
                        <i class="fas fa-question"></i>
                    </div>
                </div>
            </div>
            <div class="row pt-2 d-md-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Status</strong>
                    {{ $usersGift->present()->status }}
                </div>
            </div>
            <div class="row pt-2 d-lg-none">
                <div class="col align-self-center">
                    <strong class="transaction-details-label">Aktion</strong>
                    @if ( $usersGift->isEditableByOwner() )
                        <div class="btn btn-primary setGiftAddress"
                             data-gift-id="{{ $usersGift->id }}"
                             data-zip="{{ $usersGift->address_plz }}"
                             data-city="{{ $usersGift->address_ort }}"
                             data-street="{{ $usersGift->address_str }}"
                             data-house="{{ $usersGift->address_num }}"
                             data-comment="{{ $usersGift->address_add }}"
                        >
                            <i class="fa fa-edit"></i> Adresse einstellen
                        </div>
                    @endif
                    @if ( $usersGift->isSent() )
                        <div data-gift-id="{{ $usersGift->id }}" class="btn btn-success setGiftReceived">
                            <i class="far fa-check-circle"></i> Als erhalten markieren
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </td>
</tr>