<div class="col-lg-12 col-md-12 seller">
    <div class="listing-item-container list-layout">
        <div class="listing-item">
            <div class="listing-item-image">
                <a href="{{ route('seller.index', $seller->alias) }}"></a>
                <img src="{{ $seller->account->logo }}" alt="">
            </div>

            <div class="listing-item-content">
                <h3>
                    <a href="{{ route('seller.index', $seller->alias) }}">{{ $seller->account->company ?? $seller->fullname }}</a>
                </h3>

                <div class="listing-item-inner">
                    <a href="{{ route('seller.index', $seller->alias) }}">
                        @if( null !== $seller->bestCashback )
                            <span>Bis <strong>{{ $seller->bestCashback->present()->discount_consumer_deal }}</strong> Cashback für Einkauf</span>
                        @endif

                        @if( null !== $seller->bestRecocash && \App\CouponTemplate::TYPE_NONE !== $seller->bestRecocash->type_provision )
                            <span>Bis <strong>{{ $seller->bestRecocash->present()->provision_agent_deal }}</strong> Prämie für Empfehlung</span>
                        @endif

                        @if( null === $seller->bestCashback && null === $seller->bestRecocash )
                            <span>Noch keine Kampagne</span>
                        @endif
                    </a>
                </div>

                @if( $seller->hasAddress() )
                    <div class="listing-item-address">
                        <i class="fa fa-map-marker"></i> {{ $seller->present()->address }}
                    </div>
                @endif
            </div>
        </div>

        <div class="deal-link">
            <a href="{{ route('seller.index', $seller->alias) }}">
                <span>Zur Seite</span> <i class="fa fa-external-link"></i>
            </a>
        </div>
    </div>
</div>