@extends('redesign.layouts.listeo.front')

@section('title', 'Auszahlung')

@section('documentTitle', 'Auszahlung')

@section('overlay-style', 'display:block')

@section('scripts-page')
    <script src="{{ asset('js/payout.js') }}"></script>
@endsection

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Auszahlung</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Auszahlung'])
                </div>
            </div>
        </div>
    </div>

    <div class="container" id="dashboardContentHolder">
        @if ( $transactions->count() )
            <div id="payoutStepsHolder">
                <div class="payoutStep" id="payoutStepTransactions">
                    <div class="payoutStepBody">
                        <h3>Jetzt auszahlen</h3>
                        @include('redesign.front.listeo.pieces.payout.transactions', ['transactions' => $transactions])
                    </div>
                    <div class="text-center margin-top-20">
                        <a class="button disabled" id="payoutStepTransactionsNextBtn">
                            Weiter <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>

                <div class="payoutStep" id="payoutStepPayment">
                    <div class="payoutStepBody">
                        <h3>Zahlungsdaten</h3>
                        @include('redesign.front.listeo.pieces.payout.payment')
                    </div>
                    <div class="text-center margin-top-20">
                        <a class="button button-cancel" id="payoutStepPaymentPrevBtn">
                            <i class="fa fa-arrow-left"></i> Zurück
                        </a>
                        <a class="button @if ( !$user->account->iban || !$user->account->iban_owner ) disabled @endif" id="payoutStepPaymentNextBtn">
                            Weiter <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>

                <div class="payoutStep" id="payoutStepSummary">
                    <div class="payoutStepBody">
                        <h3 class="margin-bottom-30">Zusammenfassung</h3>
                        <div class="margin-bottom-30">
                            <h4>Transaktionen</h4>
                            @include('redesign.front.user.pieces.payouts.summary', ['transactions' => $transactions])
                        </div>
                        <div class="margin-bottom-30">
                            <h4>Gesamtsumme</h4>
                            <div id="payoutSummaryTotal">
                                <nobr><span class="value">0</span> <span class="unit">€</span></nobr>
                            </div>
                        </div>
                        <div class="margin-bottom-30">
                            <h4>Auszahlungsmethode</h4>
                            <div id="summaryPaymentBank">
                                <i class="fa fa-university"></i> Bank Konto
                            </div>
                        </div>
                    </div>
                    <div class="text-center margin-top-20">
                        <a class="button button-cancel" id="payoutStepSummaryPrevBtn">
                            <i class="fa fa-arrow-left"></i> Zurück
                        </a>
                        <a class="button" id="payoutStepSummaryNextBtn">
                            Auszahlen <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        @else
            <h3 class="margin-bottom-50">Du kannst aktuell noch keine Auszahlung vornehmen</h3>
            <div class="text-center margin-bottom-100">
                <a class="button" href="{{ route('user.transactions') }}">
                    <i class="fa fa-credit-card"></i> Zurück zum Konto
                </a>
            </div>
        @endif
    </div>
@endsection