@extends('redesign.layouts.front')

@section('title', 'Meine Geschenke')

@section('body-class', 'front page-gifts')

@section('scripts-page')
    <script src="{{ asset('js/front.js') }}"></script>
@endsection

@section('document')
    <section class="mt-5">
        <div class="container">
            <h1>Meine Geschenke</h1>
        </div>
    </section>

    <section class="pt-0 pt-sm-5 pb-5">
        <div class="container">
            @if ( $usersGifts->count() )
                @include('redesign.front.user.pieces.gifts.table', ['usersGifts' => $usersGifts])
            @else
                <h4>Du hast noch keine Geschenke erhalten</h4>
            @endif
        </div>
    </section>

    <input type="hidden" id="addressZip" value="{{ Auth::user()->account->zip }}" />
    <input type="hidden" id="addressCity" value="{{ Auth::user()->account->city }}" />
    <input type="hidden" id="addressStreet" value="{{ Auth::user()->account->street }}" />
    <input type="hidden" id="addressHouse" value="{{ Auth::user()->account->housenumber }}" />
@endsection