@extends('redesign.layouts.listeo.front')

@section('title', 'Dashboard')

@section('body-class', 'user-dashboard')

@section('document')
    <div id="titlebar" class="gradient">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    @if(!$user->email_verified)
                        <div class="notification warning margin-bottom-40">
                            <p><span>Bestätigungsmail</span></p>
                            <p>Bitte bestätige Deine E-Mail, damit Du Dein Cashback auszahlen kannst. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                            <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.</p>
                        </div>
                    @endif

                    @if( !$user->hasProfileFilled() )
                    <div class="notification warning margin-bottom-40">
                        <p>Bitte vervollständige <a href="{{ route('user.profile') }}">Dein Profil</a>.</p>
                    </div>
                    @endif

                    <div class="user-profile-titlebar margin-bottom-40">
                        <div class="user-profile-avatar"><img src="{{ $user->userpic }}" alt=""></div>
                        <div class="user-profile-name">
                            <h2>{{ $user->fullname }}</h2>
                            <div class="user-profile-counters">
                                <a href="{{ route('user.transactions') }}">
                                    <span class="sumHolder paidOutSum">{{ Format::currency($totals->paid_out) }} Ausgezahlt</span>
                                    <span class="separator"> | </span>
                                    <span class="sumHolder pendingSum">{{ Format::currency($totals->pending) }} Offen</span>
                                    <span class="separator"> | </span>
                                    <span class="sumHolder allocatedSum">{{ Format::currency($totals->allocated) }} Kontostand</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    @include('redesign.front.user.pieces.dashboard.progressbar')
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row sticky-wrapper">
            <div class="col-lg-4 col-md-4 margin-top-0">
                @include('redesign.front.user.pieces.dashboard.help')
            </div>

            <div class="col-lg-8 col-md-8 padding-left-30">
                @include('redesign.front.user.pieces.dashboard.coupons')

                @include('redesign.front.user.pieces.dashboard.sellers')
            </div>
        </div>
    </div>
@endsection