@extends('redesign.layouts.listeo.front')

@section('title', 'Meine RECO.BONs')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Meine RECO.BONs</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Meine RECO.BONs'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        @if ( $coupons['consumer']->count() )
            <div id="listing-nav" class="listing-nav-container">
                <ul class="listing-nav">
                    @if( isset($coupons['consumer']['active']) )
                        <li><a href="#listing-active">Aktiv <span class="favs-counter">{{ $coupons['consumer']['active']->count() }}</span></a></li>
                    @endif

                    @if( isset($coupons['consumer']['redeemed']) )
                        <li><a href="#listing-redeemed">Eingelöst <span class="favs-counter">{{ $coupons['consumer']['redeemed']->count() }}</span></a></li>
                    @endif

                    @if( isset($coupons['consumer']['paid']) )
                        <li><a href="#listing-paid">Bezahlt <span class="favs-counter">{{ $coupons['consumer']['paid']->count() }}</span></a></li>
                    @endif

                    @if( isset($coupons['consumer']['done']) )
                        <li><a href="#listing-done">Erledigt <span class="favs-counter">{{ $coupons['consumer']['done']->count() }}</span></a></li>
                    @endif
                </ul>
            </div>

            @if ( isset($coupons['consumer']['active']) )
                <div id="listing-active" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Aktiv</h3>
                    @include('redesign.front.listeo.pieces.coupons', ['coupons' => $coupons['consumer']['active']])
                </div>
            @endif

            @if ( isset($coupons['consumer']['redeemed']) )
                <div id="listing-redeemed" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Eingelöst</h3>
                    @include('redesign.front.listeo.pieces.coupons', ['coupons' => $coupons['consumer']['redeemed']])
                </div>
            @endif

            @if ( isset($coupons['consumer']['paid']) )
                <div id="listing-paid" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Bezahlt</h3>
                    @include('redesign.front.listeo.pieces.coupons', ['coupons' => $coupons['consumer']['paid']])
                </div>
            @endif

            @if ( isset($coupons['consumer']['done']) )
                <div id="listing-done" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Erledigt</h3>
                    @include('redesign.front.listeo.pieces.coupons', ['coupons' => $coupons['consumer']['done']])
                </div>
            @endif
        @else
            <h3 class="margin-bottom-100">Du hast noch keine RECO.BONs.</h3>
        @endif
    </div>
@endsection