@extends('redesign.layouts.listeo.front')

@section('title', 'Datenschutzerklärung')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2>Datenschutzerklärung</h2>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Datenschutzerklärung'])
                </div>
            </div>
        </div>
    </div>

    <div class="container padding-bottom-50">
        <div class="text-justify">
            <p><strong>Erklärung zu Datenschutz und Datensicherheit für Empfehler</strong></p>
            <p>Diese Datenschutzerklärung gilt für die Nutzung des Portals www.reco.ma für Empfehler.</p>

            <p><strong>1. Datenschutz</strong></p>
            <p>Wir nehmen den Schutz Ihrer persönlichen Daten sehr ernst. Im Folgenden unterrichten wir Sie über Art, Umfang und Zwecke der Erhebung, Verwendung und Weitergabe personenbezogener Daten.</p>
            <p>Sie können diese Datenschutzerklärung jederzeit auf unserer Website abrufen, speichern und ausdrucken.</p>
            <p>Sie können jederzeit einen Anspruch auf Auskunft-, Berichtigung-, Löschung oder Widerruf geltend machen.</p>

            <p><strong>1.1 Erhebung, Nutzung und Verarbeitung personenbezogener Daten</strong></p>
            <p><strong>1.1.1 Nutzungsdaten</strong></p>
            <p>Wir erheben, speichern und verwenden personenbezogene Daten, soweit Sie unser Internetangebot während Ihres Besuches nutzen (Nutzungsdaten) und die Website reco.ma besuchen. Dazu gehören insbesondere Merkmale zu Ihrer Identifikation und Angaben zu Beginn und Ende sowie des Umfangs der Nutzung unseres Angebotes. Wir verwenden diese Nutzungsdaten, damit wir den Service unserer Seiten verbessern und attraktiver gestalten können. Darüber hinaus auch, damit wir einen Überblick über Ihr Nutzungsverhalten bezüglich unseres Seitenangebotes erhalten.</p>
            <p>Standardmäßig werden folgende Daten erfasst:</p>
            <p>Die Verbindungsdaten des anfragenden Rechners, den Benutzernamen, das Datum, die Uhrzeit und die Dauer des Besuches, die Erkennungsdaten des verwendeten Browser- und Betriebssystem-Typs sowie die Website, von der aus Sie die Websites von reco.ma besuchen.</p>
            <p><strong>1.1.2 Personenbezogene Daten</strong></p>
            <p>Soweit Sie uns personenbezogene Daten insbesondere z.B. durch Ihr Anlegen eines Profils zur Verfügung gestellt haben, verwenden wir diese Daten nur zur Beantwortung Ihrer Anfragen, zur Vermittlung von Projekten, zur Abwicklung der mit Ihnen evtl. geschlossenen Verträge, insbesondere im Rahmen unserer Vorschläge gegenüber Unternehmen und Partner und für die technische Administration.</p>
            <p>Personenbezogene Daten (gem. § 3 Abs. 1 BDSG) sind Einzelangaben über persönliche (z.B. Name, Anschrift, Geburtstag, etc.) oder sachliche Verhältnisse (z.B. angebotene Dienstleistungen) einer bestimmten oder bestimmbaren natürlichen Person.</p>
            <p>Ihre personenbezogenen Daten werden an Dritte nur weitergegeben oder sonst übermittelt, wenn dies zum Zwecke einer Vertragsanbahnung oder -abwicklung erforderlich ist, dies zu Abrechnungszwecken erforderlich ist oder Sie zuvor eingewilligt haben.</p>
            <p>Ihre Daten werden in einem Benutzerkonto zusammengefasst, das nur für RECO.MA sichtbar ist. Darüber hinaus erstellen Sie ein öffentliches Profil zu Ihrer persönlichen Präsentation als Empfehler, das andere Teilnehmer des Portal sehen können.</p>
            <p>Sofern zwischen Ihnen und uns ein Vertragsverhältnis begründet, inhaltlich ausgestaltet oder ge- ändert werden soll, erheben und verwenden wir folgende personenbezogene Daten von Ihnen,</p>
            <p>die Sie bei der Registrierung angeben:</p>
            <p>Anrede, Vorname, Nachname, E-Mailadresse, Handynummer, Telefonnummer, Faxnummer, Portrait, Adresse (Straße, Hausnummer, Postleitzahl, Stadt), Bankverbindungsdaten Außerdem speichern wir die Ihnen zugeteilten Gutscheine und archivieren diese für Sie für die Dauer Ihrer Registrierung.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, speichert und verwendet, soweit dies für die Nutzung der Internetseite und des Angebots erforderlich ist.</strong></p>

            <p><strong>1.2. Weitergabe</strong></p>
            <p>Um herauszufinden, ob Ihre Angebote und Anforderungen den Profilen von Partnern entsprechen, wird mit Ihren Daten ein Profil erstellt, das dann den Anforderungen für Kampagnen abgeglichen wird. Der Partner kann sich damit besser über Sie als Empfehler informieren, wenn er einen Gutschein einem Nutzer anbieten möchte.</p>
            <p>Zu diesem Zweck sind Ihre Profil-Daten (Anrede, Vorname, Nachname, E-Mailadresse, Ort, Postleitzahl) für registrierte Partner und Nutzer im Portal sichtbar.</p>
            <p>Ihre personenbezogenen Daten werden wir an Dritte nur weitergeben oder sonst übermitteln, soweit dies zum Zwecke der Vertragsabwicklung erforderlich ist. Darüber hinaus können wir im Einzelfall gesetzlich verpflichtet sein, Auskunft über Ihre personenbezogenen Daten an öffentliche Stellen zu erteilen. Dies kann insbesondere im Falle der Strafverfolgung oder Gefahrenabwehr erforderlich sein.</p>
            <p class="notification notice"><strong>Durch meine Registrierung willige ich ein, dass RECO,MA meine personenbezogenen Daten im zuvor genannten Umfang erhebt, verarbeitet, speichert, verwendet und an Dritte weitergibt, soweit dies für die Vertragsabwicklung oder Abwicklung der Projekte erforderlich ist.</strong></p>

            <p><strong>1.3 Cookies, Plug-Ins, Social Media</strong></p>
            <p><strong>1.3.1 Cookies</strong></p>
            <p>Wir nutzen sogenannte &laquo;Cookies&raquo;, um Sie als unseren Nutzer zu erkennen und Ihnen so einen reibungslosen Besuch zu ermöglichen. Cookies sind kleine Textdateien, die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung der Website durch Sie ermöglichen. Eine Zusammenführung dieser Daten mit anderen Datenquellen wird von uns nicht vorgenommen. Die meisten der von uns verwendeten Cookies sind so genannte &laquo;Session-Cookies&raquo;, die gelöscht werden, wenn sie ihre Browsersitzung beenden. Langzeit-Cookies ermöglichen es uns unter anderem, Sie als Besucher unserer Seite wiederzuerkennen und somit diese Seite für Sie komfortabler zu gestalten.</p>
            <p>Die meisten Browser akzeptieren Cookies standardmäßig. Sie haben aber die Möglichkeit, Ihren Browser so einzustellen, dass das automatische Abspeichern von Cookies verhindert wird. Sie können temporäre und gespeicherte Cookies unabhängig voneinander zulassen oder verbieten. Das Akzeptieren von Cookies ist keine Voraussetzung zum Besuch unseres Onlineangebotes. Wenn Sie Cookies deaktivieren, stehen Ihnen unter Umständen bestimmte Funktionen auf der Website von reco.ma nicht zur Verfügung, und einige Seiten werden möglicherweise nicht richtig angezeigt. Um unsere angebotenen Funktionalitäten voll nutzen zu können, müssen Cookies zugelassen werden.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir durch Verwendung von sog. Cookies im zuvor genannten Umfang zu dem zuvor genannten Zweck erhebt, verarbeitet, speichert und verwendet.</strong></p>
            <p><strong>1.3.2 Marktforschung und Statistik</strong></p>
            <p>Ihre Daten (s. Ziffer 1.1.1 und 1.1.2), die beim Besuch dieser Website erfasst werden, werden für die statistische Auswertung mit Google Analytics (s. Ziffer 1.3.4) und zur bedarfsgerechten Gestaltung unseres Internetangebotes verwendet.</p>
            <p>Wir geben Daten zur Auswertung an unsere Statistikdienstleister und die Fa. Google Inc. weiter (tracking). Sie können diesem Tracking jederzeit widersprechen (siehe unten Ziffer 1.3.3). In diesem Fall können wir Ihnen keine personalisierten Inhalte zur Verfügung stellen.</p>
            <p><strong>1.3.3 Webanalyse mit Google Analytics</strong></p>
            <p>Wir nutzen auf unserer Website Google Analytics, einen Webanalysedienst der Fa. Google Inc. 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA (&laquo;Google&raquo;). Google Analytics setzt&laquo;Cookies&raquo; ein, die die Auswertung Ihrer Nutzung unserer Website ermöglichen (nähere Informationen zu Cookies siehe auch oben Ziffer 1.3.1). Erfasst werden zum Beispiel Informationen über das von Ihnen eingesetzte Betriebssystem, Ihren Browser, Ihre IP-Adresse, etc. Diese Daten werden an einen Server von Google in den USA übertragen und dort gespeichert. Unsere Website verwendet Google Analytics unter Verwendung der Erweiterung &laquo;gat._anonymizeIp();&raquo;, damit die Erfassung von IP-Adressen anonymisiert erfolgt. Diese Erweiterung führt dazu, dass Google die IP-Adressen der Nutzer aus der Europäischen Union kürzt, was eine direkte Personenbeziehbarkeit dieser Daten ausschließt.</p>
            <p>Google wird die erhobenen Daten in unserem Auftrag nutzen, um die Verwendung unserer Website durch Sie auszuwerten, um Berichte über Nutzerverhalten zusammenzustellen und um uns gegenüber weitere, verbundene Dienstleistungen zu erbringen. Die von Ihrem Browser an Google übermittelte IP-Adresse wird nicht mit anderen Daten zusammengeführt.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, speichert und zu dem zuvor genannten Zweck an Google weitergibt, und diese Daten im zuvor genannten Umfang erhoben, gespeichert, verarbeitet und übermittelt werden.</strong></p>
            <p><strong>1.3.4 Webanalyse mit PIWIK</strong></p>
            <p>Wir nutzen auf unserem Portal Piwik, eine Open-Source-Software zur statistischen Auswertung der Besucherzugriffe. Piwik verwendet sog. &laquo;Cookies&raquo;, Textdateien (1.3.1), die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung der Website durch Sie ermöglichen. Die durch den Cookie erzeugten Informationen über Ihre Benutzung dieses Internetangebotes werden auf dem Server des Anbieters in Deutschland gespeichert. Die IP-Adresse wird sofort nach der Verarbeitung und vor deren Speicherung anonymisiert. Sie können die Installation der Cookies durch eine entsprechende Einstellung Ihrer Browser-Software verhindern; wir weisen Sie jedoch darauf hin, dass Sie in diesem Fall gegebenenfalls nicht sämtliche Funktionen dieser Website vollumfänglich nutzen können.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, nutzt und speichert.</strong></p>

            <p><strong>1.4 Newsletter</strong></p>
            <p>Wir bieten Ihnen auf unserem Portal die Möglichkeit, unseren Newsletter zu abonnieren. Um unseren Newsletter empfangen zu können, benötigen Sie eine gültige E-Mailadresse. Sofern Sie unseren Newsletter abonniert haben, verwenden wir Ihre E-Mail-Adresse, Ihren Vor- und Zunamen und Anrede, um Ihnen einen persönlichen Newsletter zuzusenden und Sie persönlich ansprechen zu können.</p>
            <p>Mit unserem Newsletter informieren wir Sie in regelmäßigen Abständen über neue Produkte, Dienstleistungen und Funktionen unseres Portals sowie RECO.BONS auf unserem Portal.</p>
            <p>Dabei wird auch festgestellt, wie häufig ein Newsletter geöffnet wird oder welche Links wie oft geklickt werden. Diese Funktion zum Leseverhalten dient nicht nur uns, sondern häufig auch den Ihnen, weil so die Inhalte eines Newsletters dem Leseverhalten der Nutzer angepasst werden können.</p>
            <p>Unser Newsletter kann jederzeit abbestellt werden, entweder durch Anklicken des Abmelde-Links im Newsletter selbst oder im Online-Shop oder per E-Mail an: <strong>abmelden@reco.ma</strong></p>
            <p class="notification notice"><strong>Durch das Abonnieren des Newsletters willige ich ein, dass ich entsprechende Nachrichten mit Werbung zu neuen Produkten, Dienstleistungen und Funktionen für RECO.MA erhalte sowie bei Aufrufen der in dem Newsletter enthaltenen Links mein Abrufverhalten dokumentiert wird und meine Daten hierzu für Verarbeitung, Speicherung und entsprechenden Nutzung übermittelt werden.</strong>

            <p><strong>1.5 Auskunfts-, Berichtigungs-, Löschungsrecht</strong></p>
            <p>Ihr Vertrauen ist uns wichtig. Daher geben wir Ihnen stets Auskunft bezüglich der Verarbeitung Ihrer personenbezogenen Daten. Unrichtige Daten können Sie jederzeit berichtigen lassen, wenn Sie uns diesbezüglich informieren. Wenn Sie Fragen haben, die Ihnen diese Datenschutzerklä- rung nicht beantworten konnte oder wenn Sie zu einem Punkt vertiefte Informationen wünschen, wenden Sie sich per E-Mail an folgende Kontaktadresse:</p>
            <p><strong>abmelden@reco.ma</strong></p>
            <p>oder schreiben Sie an</p>
            <p><strong>RECO.MA GmbH, Zur Hollergewann 3, 35638 Leun</strong></p>
            <p>Dort erhalten Sie jederzeit kostenfrei Auskunft, auch ohne Angabe von Gründen Ihrerseits, über Ihre bei uns gespeicherten Daten.</p>
            <p>Sie haben das Recht, eine erteilte Einwilligung mit Wirkung für die Zukunft jederzeit zu widerrufen.</p>
            <p>Sie können jederzeit Ihre bei uns erhobenen personenbezogenen Daten sperren oder berichtigen lassen. Auch können Sie jederzeit die uns erteilte Einwilligung zur Datenerhebung, Speicherung, Verarbeitung und Verwendung ohne Angaben von Gründen widerrufen. Dazu genügt es, Ihren Widerruf in Textform (z.B. E-Mail, Fax oder Brief) an die zuvor genannte Adresse zu senden.</p>
            <p>Die Löschung gespeicherter personenbezogener Daten erfolgt, wenn Sie Ihre Einwilligung zur Speicherung widerrufen, wenn ihre Kenntnis zur Erfüllung des mit der Speicherung verfolgten Zwecks nicht mehr erforderlich ist oder wenn ihre Speicherung aus sonstigen gesetzlichen Gründen unzulässig ist.</p>
            <p>Eine Sperrung oder Löschung Ihrer Daten kann nicht erfolgen, soweit wir Ihre Daten zwingend zur Vertragserfüllung benötigen oder zu deren Aufbewahrung gesetzlich verpflichtet sind.</p>

            <p><strong>1.6 Kontaktformular</strong></p>
            <p>Wir bieten Ihnen auf unserer Seite die Möglichkeit, mit uns per E-Mail <strong>[info@reco.ma]</strong> und/oder über ein Kontaktformular in Verbindung zu treten. In diesem Fall werden die vom Empfehler gemachten Angaben zum Zwecke der Bearbeitung seiner Kontaktaufnahme gespeichert. Eine Weitergabe an Dritte erfolgt nicht. Ein Abgleich der so erhobenen Daten mit Daten, die möglicherweise durch andere Komponenten unserer Seite erhoben werden, erfolgt ebenfalls nicht.</p>

            <p><strong>1.7 Änderungsvorbehalt</strong></p>
            <p>Bitte beachten Sie, dass sich Datenschutzbestimmungen ändern können. Es ist daher ratsam und erforderlich, sich über Veränderungen der gesetzlichen Bestimmungen und der Praxis von Unternehmen, wie z. B. der Fa. Google Inc., Facebook etc., in regelmäßigen Abständen zu informieren.</p>

            <p><strong>1.8 Links zu Websites anderer Anbieter</strong></p>
            <p>Unsere Websites können Links zu Websites anderer Anbieter enthalten. Wir weisen darauf hin, dass diese Datenschutzerklärung ausschließlich für die Website von reco.ma gilt.</p>
            <p>Wir haben keinen Einfluss darauf und kontrollieren nicht, dass andere Anbieter die geltenden Datenschutzbestimmungen einhalten und welche Inhalte die Seiten anderer Anbieter beinhalten. Ausdrücklich machen wir uns die Inhalte fremder Seiten nicht zu Eigen.</p>

            <p><strong>2. Datensicherheit</strong></p>
            <p>Absolute Datensicherheit ist beim Datenaustausch über das Internet nicht möglich. RECO.MA ist stets bemüht, die Daten sicher zu speichern und zu verarbeiten. Allerdings können auch die Unternehmen zu einer höheren Sicherheit beitragen. Sie können mithelfen, um sich selbst und andere vor Missbrauch zu schützen. Unterstützen Sie uns beim Bemühen Ihre persönlichen Daten zu sichern, indem Sie niemals Ihr RECO.MA-Passwort weitergeben und uns bei Verdacht eines Passwortmissbrauchs unterrichten.</p>

            <p><strong>Erklärung zu Datenschutz und Datensicherheit für NUTZER</strong></p>
            <p><strong>Diese Datenschutzerklärung gilt für die Nutzung des Portals www.reco.ma für Nutzer.</strong></p>

            <p><strong>1. Datenschutz</strong></p>
            <p>Wir nehmen den Schutz Ihrer persönlichen Daten sehr ernst. Im Folgenden unterrichten wir Sie über Art, Umfang und Zwecke der Erhebung, Verwendung und Weitergabe personenbezogener Daten.</p>
            <p>Sie können diese Datenschutzerklärung jederzeit auf unserer Website abrufen, speichern und ausdrucken.</p>
            <p>Sie können jederzeit einen Anspruch auf Auskunft-, Berichtigung-, Löschung oder Widerruf geltend machen.</p>

            <p><strong>1.1 Erhebung, Nutzung und Verarbeitung personenbezogener Daten</strong></p>
            <p><strong>1.1.1 Nutzungsdaten</strong></p>
            <p>Wir erheben, speichern und verwenden personenbezogene Daten, soweit Sie unser Internetangebot während Ihres Besuches nutzen (Nutzungsdaten) und die Website reco.ma besuchen. Dazu gehören insbesondere Merkmale zu Ihrer Identifikation und Angaben zu Beginn und Ende sowie des Umfangs der Nutzung unseres Angebotes. Wir verwenden diese Nutzungsdaten, damit wir den Service unserer Seiten verbessern und attraktiver gestalten können. Darüber hinaus auch, damit wir einen Überblick über Ihr Nutzungsverhalten bezüglich unseres Seitenangebotes erhalten.</p>
            <p>Standardmäßig werden folgende Daten erfasst:</p>
            <p>Die Verbindungsdaten des anfragenden Rechners, den Benutzernamen, das Datum, die Uhrzeit und die Dauer des Besuches, die Erkennungsdaten des verwendeten Browser- und Betriebssystem-Typs sowie die Website, von der aus Sie die Websites von reco.ma besuchen.</p>
            <p><strong>1.1.2 Personenbezogene Daten</strong></p>
            <p>Soweit Sie uns personenbezogene Daten insbesondere z.B. durch Ihr Anlegen eines Profils zur Verfügung gestellt haben, verwenden wir diese Daten nur zur Beantwortung Ihrer Anfragen, zur Vermittlung von Projekten, zur Abwicklung der mit Ihnen evtl. geschlossenen Verträge, insbesondere im Rahmen unserer Vorschläge gegenüber Inhalte- und Werbeproduzenten und für die technische Administration.</p>
            <p>Personenbezogene Daten (gem. § 3 Abs. 1 BDSG) sind Einzelangaben über persönliche (z.B. Name, Anschrift, Geburtstag, etc.) oder sachliche Verhältnisse (z.B. angebotene Dienstleistungen) einer bestimmten oder bestimmbaren natürlichen Person.</p>
            <p>Ihre personenbezogenen Daten werden an Dritte nur weitergegeben oder sonst übermittelt, wenn dies zum Zwecke einer Vertragsanbahnung oder -abwicklung erforderlich ist, dies zu Abrechnungszwecken erforderlich ist oder Sie zuvor eingewilligt haben.</p>
            <p>Ihre Daten werden in einem Benutzerkonto zusammengefasst, das nur für RECO.MA sichtbar ist. Sofern zwischen Ihnen und uns ein Vertragsverhältnis begründet, inhaltlich ausgestaltet oder ge- ändert werden soll, erheben und verwenden wir folgende personenbezogene Daten von Ihnen,</p>
            <p>die Sie bei der Registrierung angeben:</p>
            <p>Anrede, Vorname, Nachname, E-Mail, Handynummer, Telefonnummer, Faxnummer, Portrait, Adresse (Straße, Hausnummer, Postleitzahl, Stadt), Bankverbindungsdaten. Außerdem speichern wir die von Ihnen genutzten und zugeteilten Gutscheine.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, speichert und verwendet, soweit dies für die Nutzung der Internetseite und des Angebots erforderlich ist.</strong></p>

            <p><strong>1.2. Weitergabe</strong></p>
            <p>Um herauszufinden, ob Angebote von Partnern und Empfehlern Ihren Anforderungen entsprechen, wird mit Ihren Daten ein Profil erstellt, das dann den Anforderungen für Kampagnen hinterlegt und abgeglichen wird. Das Portal, der Partner und Empfehler kann sich damit über Sie als Verbraucher informieren, wenn Sie einen Gutschein von einem Empfehler angeboten bekommen. Zu diesem Zweck sind Ihre Profil-Daten für registrierte Partner und Empfehler im Portal sichtbar. Ihre personenbezogenen Daten werden wir an Dritte nur weitergeben oder sonst übermitteln, soweit dies zum Zwecke der Vertragsabwicklung erforderlich ist. Darüber hinaus können wir im Einzelfall gesetzlich verpflichtet sein, Auskunft über Ihre personenbezogenen Daten an öffentliche Stellen zu erteilen. Dies kann insbesondere im Falle der Strafverfolgung oder Gefahrenabwehr erforderlich sein.</p>
            <p class="notification notice"><strong>Durch meine Registrierung willige ich ein, dass RECO,MA meine personenbezogenen Daten im zuvor genannten Umfang erhebt, verarbeitet, speichert, verwendet und an Dritte weitergibt, soweit dies für die Vertragsabwicklung oder Abwicklung der Projekte erforderlich ist.</strong></p>

            <p><strong>1.3 Cookies, Plug-Ins, Social Media</strong></p>
            <p><strong>1.3.1 Cookies</strong>
            <p>Wir nutzen sogenannte &laquo;Cookies&raquo;, um Sie als unseren Nutzer zu erkennen und Ihnen so einen reibungslosen Besuch zu ermöglichen. Cookies sind kleine Textdateien, die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung der Website durch Sie ermöglichen. Eine Zusammenführung dieser Daten mit anderen Datenquellen wird von uns nicht vorgenommen. Die meisten der von uns verwendeten Cookies sind so genannte &laquo;Session-Cookies&raquo;, die gelöscht werden, wenn sie ihre Browsersitzung beenden. Langzeit-Cookies ermöglichen es uns unter anderem, Sie als Besucher unserer Seite wiederzuerkennen und somit diese Seite für Sie komfortabler zu gestalten.</p>
            <p>Die meisten Browser akzeptieren Cookies standardmäßig. Sie haben aber die Möglichkeit, Ihren Browser so einzustellen, dass das automatische Abspeichern von Cookies verhindert wird. Sie können temporäre und gespeicherte Cookies unabhängig voneinander zulassen oder verbieten. Das Akzeptieren von Cookies ist keine Voraussetzung zum Besuch unseres Onlineangebotes. Wenn Sie Cookies deaktivieren, stehen Ihnen unter Umständen bestimmte Funktionen auf der Website von reco.ma nicht zur Verfügung, und einige Seiten werden möglicherweise nicht richtig angezeigt. Um unsere angebotenen Funktionalitäten voll nutzen zu können, müssen Cookies zugelassen werden.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir durch Verwendung von sog. Cookies im zuvor genannten Umfang zu dem zuvor genannten Zweck erhebt, verarbeitet, speichert und verwendet.</strong></p>
            <p><strong>1.3.2 Marktforschung und Statistik</strong></p>
            <p>Ihre Daten (s. Ziffer 1.1.1 und 1.1.2), die beim Besuch dieser Website erfasst werden, werden für die statistische Auswertung mit Google Analytics (s. Ziffer 1.3.4) und zur bedarfsgerechten Gestaltung unseres Internetangebotes verwendet.</p>
            <p>Wir geben Daten zur Auswertung an unsere Statistikdienstleister und die Fa. Google Inc. weiter (tracking). Sie können diesem Tracking jederzeit widersprechen (siehe unten Ziffer 1.3.3). In diesem Fall können wir Ihnen keine personalisierten Inhalte zur Verfügung stellen.</p>
            <p><strong>1.3.3 Webanalyse mit Google Analytics</strong></p>
            <p>Wir nutzen auf unserer Website Google Analytics, einen Webanalysedienst der Fa. Google Inc. 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA (&laquo;Google&raquo;). Google Analytics setzt&laquo;Cookies&raquo; ein, die die Auswertung Ihrer Nutzung unserer Website ermöglichen (nähere Informationen zu Cookies siehe auch oben Ziffer 1.3.1). Erfasst werden zum Beispiel Informationen über das von Ihnen eingesetzte Betriebssystem, Ihren Browser, Ihre IP-Adresse, etc. Diese Daten werden an einen Server von Google in den USA übertragen und dort gespeichert. Unsere Website verwendet Google Analytics unter Verwendung der Erweiterung &laquo;gat._anonymizeIp();&raquo;, damit die Erfassung von IP-Adressen anonymisiert erfolgt. Diese Erweiterung führt dazu, dass Google die IP-Adressen der Nutzer aus der Europäischen Union kürzt, was eine direkte Personenbeziehbarkeit dieser Daten ausschließt.</p>
            <p>Google wird die erhobenen Daten in unserem Auftrag nutzen, um die Verwendung unserer Website durch Sie auszuwerten, um Berichte über Nutzerverhalten zusammenzustellen und um uns gegenüber weitere, verbundene Dienstleistungen zu erbringen. Die von Ihrem Browser an Google übermittelte IP-Adresse wird nicht mit anderen Daten zusammengeführt.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, speichert und zu dem zuvor genannten Zweck an Google weitergibt, und diese Daten im zuvor genannten Umfang erhoben, gespeichert, verarbeitet und übermittelt werden.</strong></p>
            <p><strong>1.3.4 Webanalyse mit PIWIK</strong></p>
            <p>Wir nutzen auf unserem Portal Piwik, eine Open-Source-Software zur statistischen Auswertung der Besucherzugriffe. Piwik verwendet sog. &laquo;Cookies&raquo;, Textdateien (1.3.1), die auf Ihrem Computer gespeichert werden und die eine Analyse der Benutzung der Website durch Sie ermöglichen. Die durch den Cookie erzeugten Informationen über Ihre Benutzung dieses Internetangebotes werden auf dem Server des Anbieters in Deutschland gespeichert. Die IP-Adresse wird sofort nach der Verarbeitung und vor deren Speicherung anonymisiert. Sie können die Installation der Cookies durch eine entsprechende Einstellung Ihrer Browser-Software verhindern; wir weisen Sie jedoch darauf hin, dass Sie in diesem Fall gegebenenfalls nicht sämtliche Funktionen dieser Website vollumfänglich nutzen können.</p>
            <p class="notification notice"><strong>Durch die Nutzung dieser Website willige ich ein, dass RECO.MA Daten von mir im zuvor genannten Umfang erhebt, verarbeitet, nutzt und speichert.</strong></p>

            <p><strong>1.4 Newsletter</strong></p>
            <p>Wir bieten Ihnen auf unserem Portal die Möglichkeit, unseren Newsletter zu abonnieren. Um unseren Newsletter empfangen zu können, benötigen Sie eine gültige E-Mailadresse. Sofern Sie unseren Newsletter abonniert haben, verwenden wir Ihre E-Mail-Adresse, Ihren Vor- und Zunamen und Anrede, um Ihnen einen persönlichen Newsletter zuzusenden und Sie persönlich ansprechen zu können.</p>
            <p>Mit unserem Newsletter informieren wir Sie in regelmäßigen Abständen über neue Produkte, Dienstleistungen und Funktionen unseres Portals sowie RECO.BONS auf unserem Portal.</p>
            <p>Dabei wird auch festgestellt, wie häufig ein Newsletter geöffnet wird oder welche Links wie oft geklickt werden. Diese Funktion zum Leseverhalten dient nicht nur uns, sondern häufig auch den Ihnen, weil so die Inhalte eines Newsletters dem Leseverhalten der Nutzer angepasst werden können.</p>
            <p>Unser Newsletter kann jederzeit abbestellt werden, entweder durch Anklicken des Abmelde-Links im Newsletter selbst oder im Online-Shop oder per E-Mail an: <strong>abmelden@reco.ma</strong></p>
            <p class="notification notice"><strong>Durch das Abonnieren des Newsletters willige ich ein, dass ich entsprechende Nachrichten mit Werbung zu neuen Produkten, Dienstleistungen und Funktionen für RECO.MA erhalte sowie bei Aufrufen der in dem Newsletter enthaltenen Links mein Abrufverhalten dokumentiert wird und meine Daten hierzu für Verarbeitung, Speicherung und entsprechenden Nutzung übermittelt werden.</strong></p>

            <p><strong>1.5 Auskunfts-, Berichtigungs-, Löschungsrecht</strong></p>
            <p>Ihr Vertrauen ist uns wichtig. Daher geben wir Ihnen stets Auskunft bezüglich der Verarbeitung Ihrer personenbezogenen Daten. Unrichtige Daten können Sie jederzeit berichtigen lassen, wenn Sie uns diesbezüglich informieren. Wenn Sie Fragen haben, die Ihnen diese Datenschutzerklä- rung nicht beantworten konnte oder wenn Sie zu einem Punkt vertiefte Informationen wünschen, wenden Sie sich per E-Mail an folgende Kontaktadresse:</p>
            <p><strong>abmelden@reco.ma</strong></p>
            <p>oder schreiben Sie an</p>
            <p><strong>RECO.MA GmbH, Zur Hollergewann 3, 35638 Leun</strong></p>
            <p>Dort erhalten Sie jederzeit kostenfrei Auskunft, auch ohne Angabe von Gründen Ihrerseits, über Ihre bei uns gespeicherten Daten.</p>
            <p>Sie haben das Recht, eine erteilte Einwilligung mit Wirkung für die Zukunft jederzeit zu widerrufen.</p>
            <p>Sie können jederzeit Ihre bei uns erhobenen personenbezogenen Daten sperren oder berichtigen lassen. Auch können Sie jederzeit die uns erteilte Einwilligung zur Datenerhebung, Speicherung, Verarbeitung und Verwendung ohne Angaben von Gründen widerrufen. Dazu genügt es, Ihren Widerruf in Textform (z.B. E-Mail, Fax oder Brief) an die zuvor genannte Adresse zu senden.</p>
            <p>Die Löschung gespeicherter personenbezogener Daten erfolgt, wenn Sie Ihre Einwilligung zur Speicherung widerrufen, wenn ihre Kenntnis zur Erfüllung des mit der Speicherung verfolgten Zwecks nicht mehr erforderlich ist oder wenn ihre Speicherung aus sonstigen gesetzlichen Gründen unzulässig ist.</p>
            <p>Eine Sperrung oder Löschung Ihrer Daten kann nicht erfolgen, soweit wir Ihre Daten zwingend zur Vertragserfüllung benötigen oder zu deren Aufbewahrung gesetzlich verpflichtet sind.</p>

            <p><strong>1.6 Kontaktformular</strong></p>
            <p>Wir bieten Ihnen auf unserer Seite die Möglichkeit, mit uns per E-Mail <strong>[info@reco.ma]</strong> und/oder
            über ein Kontaktformular in Verbindung zu treten. In diesem Fall werden die vom Nutzer gemachten Angaben zum Zwecke der Bearbeitung seiner Kontaktaufnahme gespeichert. Eine Weitergabe an Dritte erfolgt nicht. Ein Abgleich der so erhobenen Daten mit Daten, die möglicherweise durch andere Komponenten unserer Seite erhoben werden, erfolgt ebenfalls nicht.</p>

            <p><strong>1.7 Änderungsvorbehalt</strong></p>
            <p>Bitte beachten Sie, dass sich Datenschutzbestimmungen ändern können. Es ist daher ratsam und erforderlich, sich über Veränderungen der gesetzlichen Bestimmungen und der Praxis von Unternehmen, wie z. B. der Fa. Google Inc., Facebook etc., in regelmäßigen Abständen zu informieren.</p>

            <p><strong>1.8 Links zu Websites anderer Anbieter</strong></p>
            <p>Unsere Websites können Links zu Websites anderer Anbieter enthalten. Wir weisen darauf hin, dass diese Datenschutzerklärung ausschließlich für die Website von reco.ma gilt. Wir haben keinen Einfluss darauf und kontrollieren nicht, dass andere Anbieter die geltenden Datenschutzbestimmungen einhalten und welche Inhalte die Seiten anderer Anbieter beinhalten. Ausdrücklich machen wir uns die Inhalte fremder Seiten nicht zu Eigen.</p>

            <p><strong>2. Datensicherheit</strong></p>
            <p>Absolute Datensicherheit ist beim Datenaustausch über das Internet nicht möglich. RECO.MA ist stets bemüht, die Daten sicher zu speichern und zu verarbeiten. Allerdings können auch die Unternehmen zu einer höheren Sicherheit beitragen. Sie können mithelfen, um sich selbst und andere vor Missbrauch zu schützen. Unterstützen Sie uns beim Bemühen Ihre persönlichen Daten zu sichern, indem Sie niemals Ihr RECO.MA-Passwort weitergeben und uns bei Verdacht eines Passwortmissbrauchs unterrichten.</p>

            <p><strong>Stand: 02.01.2017</strong></p>
        </div>
    </div>
@endsection