@extends('redesign.layouts.listeo.front')

@section('title', 'FAQ')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2>FAQ</h2>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'FAQ'])
                </div>
            </div>
        </div>
    </div>

    <div class="container padding-bottom-50">
        <div class="text-justify">
            @foreach ($faq as $group => $questions)
                <h3 class="margin-bottom-50 margin-top-50">{{ $group }}</h3>
                @foreach ($questions as $k => $v)
                <div class="toggle-wrap">
                    <span class="trigger"><a href="#">{{ $v['question'] }}<i class="sl sl-icon-plus"></i></a></span>
                    <div class="toggle-container">
                        {!! $v['answer'] !!}
                    </div>
                </div>
                @endforeach
            @endforeach
            </div>
        </div>
    </div>
@endsection