@extends('redesign.layouts.listeo.front')

@section('title', 'AGB')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2>AGB</h2>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'AGB'])
                </div>
            </div>
        </div>
    </div>

    <div class="container padding-bottom-50">
        <div class="text-justify">
            <p><strong>AGB (Nutzungsbedingungen) für EMPFEHLER (&laquo;EMPFEHLER&raquo;)</strong></p>
            <p><strong>Präambel</strong></p>
            <p>Die RECO.MA GmbH, Zur Hollergewann, 35638 Leun (nachfolgend &laquo;PORTAL&raquo;) betreibt unter der Internetadresse www.reco.ma eine Online-Plattform (nachfolgend &laquo;PLATTFORM&raquo;) für Empfehlungs-Marketing für Unternehmen (nachfolgend &laquo;PARTNER&raquo;), EMPFEHLER (nachfolgend &laquo;EMPFEHLER&raquo;) und Interessenten (&laquo;NUTZER&raquo;). PARTNER können dabei über EMPFEHLER den NUTZERN Gutscheine für Dienstleistungen und Waren (&laquo;RECO.BONS&raquo;) zukommen lassen, wofür EMPFEHLER eine Provision vom PARTNER erhalten.</p>
            <p>EMPFEHLER können gute Unternehmen empfehlen, indem sie ihre Kontakte zu interessierten NUTZERN nutzen. EMPFEHLER dürfen nur bei vorliegender Einwilligung der NUTZER Empfehlungen für PARTNER und PORTAL aussprechen und RECO.BONS verteilen.</p>
            <p>Darüber hinaus können EMPFEHLER auch weitere Unternehmen als PARTNER anwerben und erhalten dafür eine Provision.</p>
            <p>An der Leistungserbringung ist PORTAL nicht beteiligt. Das PORTAL regelt nur die Inanspruchnahme und Organisation der Gutscheine.</p>
            <p>Aus Gründen der besseren Lesbarkeit wird auf die gleichzeitige Verwendung männlicher und weiblicher Sprachformen verzichtet. Sämtliche Personenbezeichnungen gelten gleichwohl für beiderlei Geschlecht.</p>
            <p><strong>§ 1 Allgemeines</strong></p>
            <ol>
                <li>Die RECO.MA GmbH betreibt die PLATTFORM auf der NUTZER nach entsprechender Registrierung RECO.BONS von teilnehmenden PARTNERN einlösen können, um vergünstigte Leistungen oder Waren in Anspruch nehmen zu können. RECO.BONS erhalten NUTZER über die Empfehlung eines EMPFEHLERS.</li>
                <li>EMPFEHLER müssen sich für die Vermittlung von RECO.BONS und für das Empfehlen von PARTNERN für den Erhalt von Provisionen auf der PLATTFORM registrieren. Um sich als Empfehler registrieren zu können, bedarf es einer Einladung durch einen bereits im Portal registrierten PARTNER.</li>
                <li>Der EMPFEHLER bestätigt mit der Registrierung, dass er volljähriger Teilnehmer ist. EMPFEHLER können Privatpersonen wie auch Unternehmen sein. Ebenso können auch PARTNER andere Unternehmen als PARTNER zur Teilnahme an der Plattform werben. Auch Mitarbeiter von RECO.MA können als EMPFEHLER tätig werden. Für die empfehlenden PARTNER und RECO.MA-Mitarbeiter gelten insoweit die Bestimmungen für EMPFEHLER. PORTAL ist berechtigt, sich die Volljährigkeit durch geeignete Unterlagen nachweisen zu lassen.</li>
                <li>Durch die Vermittlung des NUTZERS oder eines PARTNERS durch EMPFEHLER, Einlösung des RECO.BONS des NUTZERS bei dem PARTNER über PORTAL, eine diesbezügliche Bereitstellung der PLATTFORM und dem Begründen eines Vertragsverhältnisses kommt keine gesellschaftsrechtliche Verbindung der Parteien und keine Stellung von PORTAL als PARTNER zustande.</li>
                <li>PORTAL behält sich das Recht vor, wenn PORTAL aufgrund einer veränderten Rechtslage oder Urteil zur Änderung der Leistung verpflichtet ist, die Leistungen zu ändern, wenn dies dem EMPFEHLER zumutbar ist. Dies gilt auch wenn eine technische Notwendigkeit eine Änderung erfordert.</li>
                <li>Zumutbare Änderungen dieser Nutzungsbedingungen werden dem EMPFEHLER in Textform, d.h. per E-Mail oder durch eine protokollierte Hinweisseite nach einem Login in das Portal mitgeteilt. Widerspricht der EMPFEHLER diesen Änderungen nicht innerhalb von sechs Wochen nach Zugang der Mitteilung, gelten die Änderungen als anerkannt.</li>
                <li>Die Nutzungsbedingungen enthalten die zwischen dem EMPFEHLER, NUTZER, PARTNER und PORTAL ausschließlich geltenden Bedingungen für die Registrierung und Nutzung der PLATTFORM.</li>
            </ol>
            <p><strong>§ 2 Entgelt</strong></p>
            <p>Die Nutzung des Portals ist für den EMPFEHLER unentgeltlich.</p>
            <p><strong>§ 3 Registrierung und Nutzung des Portals</strong></p>
            <ol>
                <li>Der Vertrag zwischen dem EMPFEHLER und PORTAL kommt durch Ausfüllen und Absenden des jeweiligen Registrierungsformulars (Eingabe der Empfehlerdaten, Akzeptanz dieser Nutzungsbedingungen und der Datenschutzvereinbarung durch Setzen eines Häkchens) mit der Übermittlung der Bestätigungs-E-Mail von PORTAL an die von dem EMPFEHLER angegebene E-Mail-Adresse zustande. Mit dem Absenden des ausgefüllten Registrierungsformulars erkennt der EMPFEHLER die Geltung dieser Nutzungsbedingungen im Rahmen des Registrierungsvorganges verbindlich an. Ein Anspruch auf Teilnahme, Registrierung oder Freischaltung besteht nicht.</li>
                <li>Mit den bei der Registrierung eingegebenen Daten wird ein Empfehlerkonto erstellt, in dem die persönlichen Daten zu Abrechnungszwecken erfasst werden. Die Daten aus dem Empfehlerkonto sind für Dritte nicht sichtbar. Außerdem kann der EMPFEHLER ein Empfehlerprofil anlegen.</li>
                <li>Für jeden EMPFEHLER kann nur ein Empfehlerkonto eingerichtet und nur ein Empfehlerprofil erstellt werden. Empfehlerkonto und Empfehlerprofil sind nicht übertragbar. Profile sind nur für registrierte Teilnehmer, d.h. für PARTNER, EMPFEHLER und NUTZER sichtbar.</li>
                <li>Etwaige Eingabefehler kann der EMPFEHLER bei der abschließenden Bestätigung vor dem Abschluss der Registrierung erkennen und mit Hilfe der &laquo;Bearbeiten-Funktion&raquo; sowie durch Betätigen der &laquo;Zurück-Funktion&raquo; des Internet-Browsers vor Absendung der Eingabe jederzeit korrigieren. Der Vertragstext wird von PORTAL nicht gespeichert; der EMPFEHLER kann diese Nutzungsbedingungen jederzeit über die Unterkategorie &laquo;AGB&raquo; von der Startseite aus erreichen und einsehen. Der EMPFEHLER hat damit die Möglichkeit, diese AGB mit der &laquo;Druck-Funktion&raquo; des Internet-Browsers auszudrucken oder die entsprechende Webseite lokal zu speichern.</li>
                <li>Alle Angaben des EMPFEHLERS müssen wahrheitsgemäß sein und sind während der Vertragslaufzeit ggfls. zu aktualisieren. Der EMPFEHLER wählt für sein Empfehlerkonto ein sicheres Passwort aus.</li>
                <li>Der EMPFEHLER hat dafür Sorge zu tragen, dass sein Empfehlerkonto ausschließlich von ihm genutzt werden kann und wird zu diesem Zweck die entsprechenden Vorkehrungen zur Geheimhaltung des jeweiligen Passwortes treffen und das Passwort nicht an Dritte weitergeben. Der EMPFEHLER ist dazu verpflichtet, PORTAL unverzüglich darüber zu informieren, wenn ihm bekannt wird, dass seine Zugangsdaten nicht autorisiert verwendet werden bzw. diese Verwendung durch eine unberechtigte Erlangung der Zugangsdaten möglich ist.</li>
                <li>Der EMPFEHLER ist bei der Nutzung der PLATTFORM verpflichtet, die geltenden Gesetze und Portalbestimmungen zu befolgen. Es liegt in der eigenen Verantwortung des EMPFEHLERS sicherzustellen, dass seine Inhalte rechtmäßig sind und keine Rechte Dritter (Urheber-, Markenrecht, Wettbewerbsrecht, Persönlichkeitsrechte etc.) verletzt werden. Der EMPFEHLER verpflichtet sich, keine unerlaubte Werbung, Spam oder unzutreffende Warnungen vor Viren, Fehlfunktionen und dergleichen zu verbreiten oder zur Teilnahme an Gewinnspielen, Schneeballsystemen, Kettenbrief-, Pyramidenspiel- und vergleichbaren Aktionen aufzufordern oder beleidigende oder verleumderische Inhalte zu erstellen oder zu verteilen oder pornografische, gewaltverherrlichende, rassistische, missbräuchliche, sittenwidrige oder nach dem Jugendschutzgesetz verletzende Inhalte zu erstellen oder verteilen. Ein Verstoß kann eine fristlose Kündigung durch PORTAL zur Folge habe sowie auch das Sperren und Entfernen der betroffenen Inhalte.</li>
                <li>Bei Verstoß gegen die Regelungen dieser AGB von PORTAL, kann der EMPFEHLER mit sofortiger Wirkung von der Nutzung der PLATTFORM ausgeschlossen werden.</li>
            </ol>
            <p><strong>§ 4 Laufzeit und Kündigung</strong></p>
            <ol>
                <li>Die Laufzeit der Basismitgliedschaft erfolgt auf unbestimmte Zeit.</li>
                <li>Der EMPFEHLER kann seine Basismitgliedschaft jederzeit kündigen, wenn er seine Kündigung in Textform erklärt.</li>
            </ol>
            <p><strong>§ 5 Vermittlung von RECO.BONS an Interessierte</strong></p>
            <ol>
                <li>Jeder registrierte EMPFEHLER kann RECO.BONS an interessierte NUTZER verteilen, sofern der PARTNER ihm hierfür RECO.BONS zur Vermittlung überlassen hat und PARTNER den EMPFEHLER oder aber generell alle EMPFEHLER freischaltet. EMPFEHLER darf nur RECO.BONS vermitteln, die ihm hierfür überlassen worden sind</li>
                <li>Die erhaltenen RECO.BONS vermittelt der EMPFEHLER an NUTZER, die ihm bekannt sind und ihm einen entsprechenden Kontakt erlaubt haben. Dabei hat der EMPFEHLER unbedingt Sorge dafür zu tragen, dass ausschließlich und nachprüfbar interessierte NUTZER RECO.BONS erhalten. Ein Verteilen von RECO.BONS an Personen, die unbekannt oder nicht interessiert oder keine Einwilligung in eine Einladung zur PLATTFORM gegeben haben, darf nicht erfolgen. Der EMPFEHLER darf nur solche Interessierte einladen, von denen er um das Einverständnis weiß und deren entsprechende Einwilligung in den Erhalt einer Einladung er schriftlich dokumentiert hat. Diese Einwilligung versichert der EMPFEHLER und wird sie archivieren, damit er im Bedarfsfall diese gegenüber PORTAL herausgeben kann</li>
                <li>Die Einzelheiten der Leistungserbringung bestimmt dabei der PARTNER mit dem NUTZER. PORTAL hat keinerlei Einfluss darauf, wie und mit welchem Inhalt die Leistung erbracht wird.</li>
                <li>Nachdem PARTNER und NUTZER die Leistungen ausgetauscht und die Zahlung des Nutzers bei PORTAL eingegangen ist, erhält der EMPFEHLER seine PROVISION nach 10 Tagen auf seinem Empfehlerkonto gutgeschrieben und kann sich diese per Überweisung auszahlen lassen.</li>
                <li>Der EMPFEHLER erwirbt mit dem Angebot von Gutscheinen keinen Anspruch auf das Einlösen. Bei den Gutscheinen handelt es sich jeweils um ein Angebot, das der PARTNER im Einzelfall akzeptieren muss. Partner muss RECO.BON akzeptieren und annehmen.</li>
            </ol>
            <p><strong>§ 6 Anwerben von PARTNERN</strong></p>
            <ol>
                <li>EMPFEHLER können PARTNER anwerben, damit diese die PLATTFORM nutzen. Beim Anwerben eines PARTNERS durch einen EMPFEHLER oder einen bereits registrierten PARTNER, erhält der EMPFEHLER eine Provisionszahlung von PORTAL.</li>
                <li>Die Provision für die Anwerbung von PARTNERN ist variabel und wird einzeln ausgewiesen.</li>
                <li>Sobald sich ein angeworbenes Unternehmen als PARTNER bei PORTAL registriert, erhält der EMPFEHLER hierfür nach 10 Tagen eine Gutschrift auf seinem Empfehlerkonto, die er sich auszahlen lassen kann.</li>
            </ol>
            <p><strong>§ 7 Vermittlungsprovision</strong></p>
            <ol>
                <li>Der EMPFEHLER erhält für jede erfolgreiche Vermittlung eines RECO.BONS eine Provision durch den PARTNER. Eine Vermittlung ist dann erfolgreich, wenn der NUTZER und der PARTNER einen Gutscheincode verwenden, d.h. bestätigt für eine Transaktion einsetzen, der EMPFEHLER diesen GUTSCHEIN an den NUTZER weitergegeben hat und das PORTAL das Entgelt von PARTNER erhalten hat.</li>
                <li>Der EMPFEHLER ermächtigt PORTAL mit dem Einzug der Provisionsgebühr vom PARTNER.</li>
                <li>Der EMPFEHLER kann sich die von PARTNER gezahlte Vermittlungsprovision nach 10 Tagen von PORTAL auszahlen lassen.</li>
                <li>Die Vermittlungsprovision ist einzelfallabhängig und wird für jede Gutscheinaktion vom PARTNER festgelegt.</li>
            </ol>
            <p><strong>§ 8 Newsletter</strong></p>
            <p>PORTAL bietet einen regelmäßigen Newsletter an, der den EMPFEHLER über aktuelle Themen und Neuerungen auf der PLATTFORM informiert. Wenn der EMPFEHLER mittels Häkchen-Setzen erklärt, dass er die Zusendung des Newsletters wünscht und den Link in der Bestätigungs-E-Mail betätigt, so erhält der EMPFEHLER regelmäßig den Newsletter an die von ihm bei der Registrierung angegebene E-Mail-Adresse zugesandt. Der EMPFEHLER kann die Einwilligung jederzeit widerrufen, z.B. mit dem in jedem Newsletter zur Abbestellung aufgeführten Link oder per E-Mail an:</p>
            <p>abmelden@reco.ma</p>
            <p>Weitere Informationen zum Newsletter finden sich in den <a class="text-primary" href="{{ route('privacy') }}">Datenschutzbestimmungen</a>.</p>
            <p><strong>§ 9 Datenschutzbestimmungen</strong></p>
            <p>Die von dem EMPFEHLER hinterlegten personenbezogenen Daten werden im Rahmen der vom EMPFEHLER abgegebenen Einwilligung zur Nutzung seiner Daten gemäß der <a class="text-primary" href="{{ route('privacy') }}">Datenschutzerklärung</a> sowie gemäß den gesetzlichen Vorschriften des Datenschutzrechtes, insbesondere denjenigen des Bundesdatenschutzgesetzes (BDSG) sowie des Telemediengesetzes (TMG) verwendet.</p>
            <p><strong>§ 10 Rechte</strong></p>
            <ol>
                <li>Der EMPFEHLER erhält ein einfaches Recht, die PLATTFORM im Rahmen des Umfangs seiner jeweiligen Mitgliedschaft für den vereinbarten Leistungszeitraum zu dem vereinbarten Zweck zu nutzen.</li>
                <li>Alle Inhalte des Portals (Texte, Bilder, Grafiken etc.) einschließlich sämtlicher Softwarebestandteile des Portals, insbesondere der Datenbank, sind urheberrechtlich sowie durch andere Schutzgesetze geschützt. Es ist untersagt, das Portal oder Bestandteile davon zu vervielfältigen, zu kopieren, zu verändern und/oder zu bearbeiten.</li>
            </ol>
            <p><strong>§ 11 Haftung</strong></p>
            <ol>
                <li>Ein Anspruch auf jederzeitige und ununterbrochene Verfügbarkeit der PLATTFORM besteht nicht. Die Datenkommunikation über das Internet kann nach dem derzeitigen Stand der Technik nicht fehlerfrei und/oder jederzeit verfügbar gewährleistet werden. PORTAL haftet nicht für technische Ausfälle oder die Verfügbarkeit des Angebotes, es sei denn, PORTAL fallen Vorsatz oder grobe Fahrlässigkeit zur Last.</li>
                <li>PORTAL ist berechtigt, Wartungs- und Pflegearbeiten an der PLATTFORM vorzunehmen und wird sich dabei bemühen, Störungen der Erreichbarkeit und Benutzbarkeit der PLATTFORM so gering wie möglich zu halten.</li>
                <li>Für andere als durch Verletzung von Leben, Körper und Gesundheit entstehende Schäden haftet PORTAL lediglich, soweit diese auf vorsätzlichem oder grob fahrlässigem Handeln oder auf schuldhafter Verletzung einer wesentlichen Vertragspflicht (sog. &laquo;Kardinalpflicht&raquo;, d. h. eine Verpflichtung, deren Erfüllung die ordnungsgemäße Durchführung des Vertrages überhaupt erst ermöglicht und auf deren Einhaltung der Vertragspartner regelmäßig vertraut und vertrauen darf) durch PORTAL oder deren Erfüllungsgehilfen beruhen.</li>
                <li>Eine darüber hinausgehende Haftung auf Schadenersatz ist ausgeschlossen. Insbesondere ist der Ersatz des entgangenen Gewinns, mittelbarer Schäden sowie sonstiger Vermögensschäden im Falle einfacher Fahrlässigkeit ausgeschlossen. Die Bestimmungen des Produkthaftungsgesetzes bleiben hiervon unberührt; unbeschränkt bleibt darüber hinaus die Haftung für das arglistige Verschweigen eines Mangels, für eine ausdrücklich garantierte Beschaffenheit sowie für Personenschäden.</li>
                <li>Sofern PORTAL leicht fahrlässig eine wesentliche Vertragspflicht verletzt, ist die Ersatzpflicht auf den typischerweise vorhersehbaren Schaden, in jedem Fall aber auf die Höhe von 5.000,- EUR beschränkt.</li>
                <li>Bei Vorliegen eines Sach- oder Rechtsmangels ist der EMPFEHLER im Übrigen im Rahmen der gesetzlichen Bestimmungen berechtigt.</li>
                <li>Der EMPFEHLER ist verpflichtet über die PLATTFORM keine Inhalte und Mittel zu verwenden, die strafbar sind oder in sonstiger Weise gegen rechtliche Vorschriften verstoßen; hierzu zählen insbesondere pornografische, volksverhetzende, urheberrechtsverletzende, wettbewerbsverletzende, sittenwidrige, beleidigende, rassistische oder extremistische Inhalte. PORTAL haftet nicht für derartige Verstöße des EMPFEHLERS. Der EMPFEHLER stellt daher PORTAL von allen Ansprüchen Dritter frei, insbesondere solche, die auf einer Verletzung von Urheberrecht, Markenrecht, Wettbewerbsrecht, Medienrecht oder anderen vertraglichen Pflichten von EMPFEHLER entstehen.</li>
                <li>Der EMPFEHLER ist verpflichtet nur Interessenten auf die PLATTFORM www.reco.ma einzuladen, die ihm gegenüber eine Einwilligung schriftlich erteilt haben. PORTAL haftet nicht für Verstöße des EMPFEHLERS, wenn VERMTTLER NUTZER unberechtigt einlädt. Der EMPFEHLER stellt daher PORTAL von allen Ansprüchen und Kosten Dritter frei, insbesondere, die aus einer Verletzung von Datenschutzrecht, Wettbewerbsrecht, Medienrecht oder anderen gesetzlichen Pflichten von EMPFEHLER entstehen. Wird PORTAL wegen solcher Verstöße in Anspruch genommen, haftet der EMPFEHLER für alle daraus bei PORTAL entstehenden Kosten.</li>
                <li><strong>PORTAL überprüft die Angaben über PARTNER, NUTZER und Gutscheine nicht und übernimmt daher auch keinerlei Gewähr für die Richtigkeit der von dem NUTZER oder PARTNER hinterlegten Daten, Qualifikationen, Angaben zur Identität etc.</strong></li>
            </ol>
            <p><strong>§ 12 Geheimhaltung</strong></p>
            <ol>
                <li>Der EMPFEHLER verpflichtet sich, über geheimhaltungsbedürftige Informationen Stillschweigen zu bewahren.</li>
                <li>Von dieser Verpflichtung ausgenommen sind solche Informationen, die
                    <ol type="a">
                        <li>dem EMPFEHLER bereits vorher ohne Verpflichtung zur Geheimhaltung bekannt waren oder</li>
                        <li>allgemein bekannt sind oder werden, ohne dass dies der EMPFEHLER zu vertreten hat oder</li>
                        <li>dem EMPFEHLER von einem Dritten ohne Geheimhaltungsverpflichtung mitgeteilt bzw. überlassen werden oder</li>
                        <li>aufgrund rechtlicher Vorschriften Behörden zugänglich zu machen sind oder</li>
                        <li>von PARTNER oder PORTAL gegenüber dem EMPFEHLER zur Bekanntmachung schriftlich freigegeben worden sind.</li>
                    </ol>
                </li>
            </ol>
            <p><strong>§ 13 Schlussbestimmungen</strong></p>
            <ol>
                <li>Für diese Vereinbarung gilt ausschließlich das Recht der Bundesrepublik Deutschland unter Ausschluss des internationalen Privatrechts sowie unter Ausschluss des UNKaufrechts über den internationalen Warenkauf (CISG), auch wenn eine Vertragspartei ihren Sitz im Ausland hat.</li>
                <li><strong>Die Europäische Kommission stellt eine Plattform zur Online-Streitbeilegung (OSPlattform) bereit, die Sie hier finden <a class="text-primary" href="ttps://webgate.ec.europa.eu/odr/" target="_blank">https://webgate.ec.europa.eu/odr/</a>. Der EMPFEHLER hat als Verbraucher daher die Möglichkeit, diese OS-Plattform für die Beilegung von Streitigkeiten zu nutzen.</strong></li>
                <li>Es gilt als Gerichtsstand unter Kaufleuten der Sitz von PORTAL.</li>
                <li>Sollte eine Bestimmung dieser Nutzungsbedingungen unwirksam sein oder werden, so berührt dies die Gültigkeit der Bestimmungen im Übrigen nicht. Anstelle der unwirksamen Bestimmung gelten die einschlägigen gesetzlichen Vorschriften.</li>
            </ol>

            <p><strong>AGB (Nutzungsbedingungen) für Interessenten (&laquo;NUTZER&raquo;)</strong></p>
            <p><strong>Präambel</strong></p>
            <p>Die RECO.MA GmbH, Zur Hollergewann 3, 35638 Leun (nachfolgend &laquo;PORTAL&raquo;) betreibt unter der Internetadresse www.reco.ma eine Online-Plattform (nachfolgend &laquo;PLATTFORM&raquo;) für Unternehmen (nachfolgend &laquo;PARTNER&raquo;), EMPFEHLER (nachfolgend &laquo;EMPFEHLER&raquo;) und Interessenten (&laquo;NUTZER&raquo;). NUTZER können die PLATTFORM nutzen, um Gutscheine (RECO.BONS) in Anspruch zu nehmen. PORTAL bietet mit der PLATTFORM eine Möglichkeit zur automatischen Steuerung von RECO.BONS. Die Erbringung der Leistung oder der Bezug von Waren erfolgt zwischen PARTNER und NUTZER direkt und außerhalb der PLATTFORM. Die PLATTFORM regelt nur die Inanspruchnahme und Organisation der RECO.BONS.</p>
            <p>Aus Gründen der besseren Lesbarkeit wird auf die gleichzeitige Verwendung männlicher und weiblicher Sprachformen verzichtet. Sämtliche Personenbezeichnungen gelten gleichwohl für beiderlei Geschlecht.</p>
            <p><strong>§ 1 Allgemeines</strong></p>
            <ol>
                <li>Die RECO.MA GmbH betreibt die PLATTFORM auf der NUTZER nach entsprechender Registrierung RECO.BONS von teilnehmenden PARTNERN zur nachträglichen Gutschrift einlösen können, um so vergünstigte Leistungen oder Waren zu erhalten. Die nachträgliche Gutschrift des RECO.BONS erfolgt nach vollständiger Bezahlung der Leistung durch den NUTZER, Einlösen des RECO.BONS durch den PARTNER und Verifizierung auf der PLATTFORM.</li>
                <li>RECO.BONS erhalten NUTZER über einen registrierten EMPFEHLER.</li>
                <li>Der NUTZER bestätigt mit der Registrierung, dass er volljähriger Teilnehmer ist. PORTAL ist berechtigt, sich die Volljährigkeit durch geeignete Unterlagen nachweisen zu lassen.</li>
                <li>Die Nutzungsbedingungen enthalten die zwischen dem NUTZER, EMPFEHLER, PARTNER und PORTAL ausschließlich geltenden Bedingungen für die Registrierung und Nutzung der PLATTFORM.</li>
                <li>Durch die Einlösung des RECO.BONS des NUTZERS bei dem PARTNER über PORTAL, eine diesbezügliche Bereitstellung der PLATTFORM und dem Begründen eines Vertragsverhältnisses kommt keine gesellschaftsrechtliche Verbindung der Parteien und keine Stellung von PORTAL als PARTNER zustande.</li>
                <li>PORTAL behält sich das Recht vor, wenn PORTAL aufgrund einer veränderten Rechtslage oder Urteil zur Änderung der Leistung verpflichtet ist, die Leistungen zu ändern, wenn dies dem NUTZER zumutbar ist. Dies gilt auch wenn eine technische Notwendigkeit eine Änderung erfordert.</li>
                <li>Zumutbare Änderungen dieser Nutzungsbedingungen werden dem NUTZER in Textform, d.h. per E-Mail oder durch eine protokollierte Hinweisseite nach einem Login in das Portal mitgeteilt. Widerspricht der NUTZER diesen Änderungen nicht innerhalb von sechs Wochen nach Zugang der Mitteilung, gelten die Änderungen als anerkannt.</li>
            </ol>
            <p><strong>§ 2 Entgelt</strong></p>
            <p>Die Nutzung der PLATTFORM ist für den NUTZER unentgeltlich.</p>
            <p><strong>§ 3 Registrierung und Nutzung des Portals</strong></p>
            <ol>
                <li>Der Vertrag zwischen dem NUTZER und PORTAL kommt durch Ausfüllen und Absenden des jeweiligen Registrierungsformulars (Eingabe der Nutzerdaten, Akzeptanz dieser Nutzungsbedingungen und der Datenschutzvereinbarung durch Setzen eines Häkchens) mit der Übermittlung der Bestätigungs-E-Mail von PORTAL an die von dem NUTZER angegebene E-Mail-Adresse zustande. Mit dem Absenden des ausgefüllten Registrierungsformulars erkennt der NUTZER die Geltung dieser Nutzungsbedingungen im Rahmen des Registrierungsvorganges verbindlich an. Ein Anspruch auf Teilnahme, Registrierung oder Freischaltung besteht nicht.</li>
                <li>Mit den bei der Registrierung eingegebenen Daten wird ein Nutzerkonto erstellt, in dem die persönlichen Daten zu Abrechnungszwecken erfasst werden. Die Daten aus dem Nutzerkonto sind für Dritte nicht sichtbar. Erstellt der NUTZER ein öffentliches Profil, so ist dieses Profil nur für registrierte Teilnehmer, d.h. für PARTNER, EMPFEHLER und NUTZER sichtbar.</li>
                <li>Für jeden NUTZER kann nur ein Nutzerkonto eingerichtet und nur ein Nutzerprofil erstellt werden. Nutzerkonto und Nutzerprofil sind nicht übertragbar. Gutschriften aus eingelösten Gutscheinen werden dem Nutzerkonto gutgeschrieben.</li>
                <li>Etwaige Eingabefehler kann der NUTZER bei der abschließenden Bestätigung vor dem Abschluss der Registrierung erkennen und mit Hilfe der &laquo;Bearbeiten-Funktion&raquo; sowie durch Betätigen der &laquo;Zurück-Funktion&raquo; des Internet-Browsers vor Absendung der Eingabe jederzeit korrigieren. Der Vertragstext wird von PORTAL nicht gespeichert; der NUTZER kann diese Nutzungsbedingungen jederzeit über die Unterkategorie &laquo;AGB&raquo; von der Startseite aus erreichen und einsehen. Der NUTZER hat damit die Möglichkeit, diese AGB mit der &laquo;Druck-Funktion&raquo; des Internet-Browsers auszudrucken oder die entsprechende Webseite lokal zu speichern.</li>
                <li>Alle Angaben des NUTZERS müssen wahrheitsgemäß sein und sind während der Vertragslaufzeit ggfls. zu aktualisieren. Der NUTZER wählt für sein Nutzerkonto ein sicheres Passwort aus.</li>
                <li>Der NUTZER hat dafür Sorge zu tragen, dass sein Nutzerkonto ausschließlich von ihm genutzt werden kann und wird zu diesem Zweck die entsprechenden Vorkehrungen zur Geheimhaltung des jeweiligen Passwortes treffen und das Passwort nicht an Dritte weitergeben. Der NUTZER ist dazu verpflichtet, PORTAL unverzüglich darüber zu informieren, wenn ihm bekannt wird, dass seine Zugangsdaten nicht autorisiert verwendet werden bzw. diese Verwendung durch eine unberechtigte Erlangung der Zugangsdaten möglich ist.</li>
                <li>Der NUTZER ist bei der Nutzung der PLATTFORM verpflichtet, die geltenden Gesetze und Portalbestimmungen zu befolgen. Es liegt in der eigenen Verantwortung des NUTZERS sicherzustellen, dass seine Inhalte rechtmäßig sind und keine Rechte Dritter (Urheber-, Markenrecht, Wettbewerbsrecht, Persönlichkeitsrechte etc.) verletzt werden. Der NUTZER verpflichtet sich, keine unerlaubte Werbung, Spam oder unzutreffende Warnungen vor Viren, Fehlfunktionen und dergleichen zu verbreiten oder zur Teilnahme an Gewinnspielen, Schneeballsystemen, Kettenbrief-, Pyramidenspiel- und vergleichbaren Aktionen aufzufordern oder beleidigende oder verleumderische Inhalte zu erstellen oder zu verteilen oder pornografische, gewaltverherrlichende, rassistische, missbräuchliche, sittenwidrige oder nach dem Jugendschutzgesetz verletzende Inhalte zu erstellen oder verteilen. Ein Verstoß kann eine fristlose Kündigung durch PORTAL zur Folge habe sowie auch das Sperren und Entfernen der betroffenen Inhalte.</li>
                <li>Bei Verstoß gegen die Regelungen dieser AGB von PORTAL, kann der NUTZER mit sofortiger Wirkung von der Nutzung der PLATTFORM ausgeschlossen werden.</li>
            </ol>
            <p><strong>§ 4 Laufzeit und Kündigung</strong></p>
            <ol>
                <li>ie Laufzeit der Basismitgliedschaft erfolgt auf unbestimmte Zeit.</li>
                <li>Der NUTZER kann seine Basismitgliedschaft jederzeit kündigen, wenn er seine Kündigung in Textform erklärt.</li>
            </ol>
            <p><strong>§ 5 Vermittlung und Einlösen von RECO.BONS</strong></p>
            <ol>
                <li>Jeder NUTZER kann RECO.BONS einlösen, die ihm nachträglich eine Preisreduktion gewähren und die ihm dafür vom EMPFEHLER angeboten werden. Dabei schlägt der EMPFEHLER dem NUTZER mittels eines RECO.BONS einen PARTNER.</li>
                <li>Der NUTZER kann dann Leistungen von einem registrierten PARTNER in Anspruch nehmen, wenn der PARTNER die Einlösung des RECO.BONS akzeptiert. Die Einzelheiten der Leistungserbringung bestimmen dabei PARTNER und NUTZER. PORTAL hat keinerlei Einfluss darauf, wie und mit welchem Inhalt die Leistung erbracht wird.</li>
                <li>Der NUTZER zeigt dem PARTNER die Bezahlung der Leistung an und fordert den PARTNER auf, dem PORTAL die Einlösung des RECO.BONS zu bestätigen, sofern der PARTNER die Bestätigung nicht schon erteilt hat.</li>
                <li>Der PARTNER zeigt PORTAL die Einlösung eines RECO.BONS an und gibt den Gutscheincode auf der PLATTFORM ein. Nachdem der PARTNER die Zahlung bestätigt hat, zieht PORTAL die Gebühr von PARTNER ein und wird nach erfolgreichem Geldeingang bei PORTAL den Gutscheinbetrag auf dem Nutzerkonto gutschreiben und der NUTZER kann sich diesen nach 10 Tagen auszahlen lassen. Das bedeutet der NUTZER zahlt zunächst den vollen Preis und erhält nachträglich eine Gutschrift.</li>
            </ol>
            <p><strong>§ 6 Newsletter</strong></p>
            <p>PORTAL bietet einen regelmäßigen Newsletter an, der den NUTZER über aktuelle Themen, Angebote und Neuerungen auf der PLATTFROM informiert. Wenn der NUTZER mittels Häkchen-Setzen erklärt, dass er die Zusendung des Newsletters wünscht und den Link in der Bestätigungs-E-Mail betätigt, so erhält der NUTZER regelmäßig den Newsletter an die von ihm bei der Registrierung angegebene E-Mail-Adresse zugesandt. Der NUTZER kann die Einwilligung jederzeit widerrufen, z.B. mit dem in jedem Newsletter zur Abbestellung aufgeführten Link oder per E-Mail an</p>
            <p>abmelden@reco.ma</p>
            <p>Weitere Informationen zum Newsletter finden sich in den <a class="text-primary" href="{{ route('privacy') }}">Datenschutzbestimmungen</a>.
            <p><strong>§ 7 Datenschutzbestimmungen</strong>
            <p>Die von dem NUTZER hinterlegten personenbezogenen Daten werden im Rahmen der vom NUTZER abgegebenen Einwilligung zur Nutzung seiner Daten gemäß der<a class="text-primary" href="{{ route('privacy') }}">Datenschutzerklärung</a> sowie gemäß den gesetzlichen Vorschriften des Datenschutzrechtes, insbesondere denjenigen des Bundesdatenschutzgesetzes (BDSG) sowie des Telemediengesetzes (TMG) verwendet.</p>
            <p><strong>§ 8 Rechte</strong></p>
            <ol>
                <li>Der NUTZER erhält ein einfaches Recht, die PLATTFORM im Rahmen des Umfangs seiner jeweiligen Mitgliedschaft für den vereinbarten Leistungszeitraum zu dem vereinbarten Zweck zu nutzen.</li>
                <li>Alle Inhalte des Portals (Texte, Bilder, Grafiken etc.) einschließlich sämtlicher Softwarebestandteile des Portals, insbesondere der Datenbank, sind urheberrechtlich sowie durch andere Schutzgesetze geschützt. Es ist untersagt, das Portal oder Bestandteile davon zu vervielfältigen, zu kopieren, zu verändern und/oder zu bearbeiten.</li>
            </ol>
            <p><strong>§ 9 Haftung</strong></p>
            <ol>
                <li>Ein Anspruch auf jederzeitige und ununterbrochene Verfügbarkeit der PLATTFORM besteht nicht. Die Datenkommunikation über das Internet kann nach dem derzeitigen Stand der Technik nicht fehlerfrei und/oder jederzeit verfügbar gewährleistet werden. PORTAL haftet nicht für technische Ausfälle oder die Verfügbarkeit des Angebotes, es sei denn, PORTAL fallen Vorsatz oder grobe Fahrlässigkeit zur Last.</li>
                <li>PORTAL ist berechtigt, Wartungs- und Pflegearbeiten an der PLATTFORM vorzunehmen und wird sich dabei bemühen, Störungen der Erreichbarkeit und Benutzbarkeit der PLATTFORM so gering wie möglich zu halten.</li>
                <li>Für andere als durch Verletzung von Leben, Körper und Gesundheit entstehende Schäden haftet PORTAL lediglich, soweit diese auf vorsätzlichem oder grob fahrlässigem Handeln oder auf schuldhafter Verletzung einer wesentlichen Vertragspflicht (sog.&laquo;Kardinalpflicht&raquo;, d. h. eine Verpflichtung, deren Erfüllung die ordnungsgemäße Durchführung des Vertrages überhaupt erst ermöglicht und auf deren Einhaltung der Vertragspartner regelmäßig vertraut und vertrauen darf) durch PORTAL oder deren Erfüllungsgehilfen beruhen.</li>
                <li>Eine darüber hinausgehende Haftung auf Schadenersatz ist ausgeschlossen. Insbesondere ist der Ersatz des entgangenen Gewinns, mittelbarer Schäden sowie sonstiger Vermögensschäden im Falle einfacher Fahrlässigkeit ausgeschlossen. Die Bestimmungen des Produkthaftungsgesetzes bleiben hiervon unberührt; unbeschränkt bleibt darüber hinaus die Haftung für das arglistige Verschweigen eines Mangels, für eine ausdrücklich garantierte Beschaffenheit sowie für Personenschäden.</li>
                <li>Sofern PORTAL leicht fahrlässig eine wesentliche Vertragspflicht verletzt, ist die Ersatzpflicht auf den typischerweise vorhersehbaren Schaden, in jedem Fall aber auf die Höhe von 5.000,- EUR beschränkt.</li>
                <li>Bei Vorliegen eines Sach- oder Rechtsmangels ist der NUTZER im Übrigen im Rahmen der gesetzlichen Bestimmungen berechtigt. Er ist berechtigt u.a. Nacherfüllung zu verlangen, nach gescheiterter Nacherfüllung von dem Vertrag zurückzutreten, den Kaufpreis zu mindern oder im Falle eines Verschuldens auf Seiten des PORTALS Schadensersatz geltend zu machen.</li>
                <li>Der NUTZER ist verpflichtet über die PLATTFORM keine Inhalte und Mittel zu verwenden, die strafbar sind oder in sonstiger Weise gegen rechtliche Vorschriften verstoßen; hierzu zählen insbesondere pornografische, volksverhetzende, urheberrechtsverletzende, wettbewerbsverletzende, sittenwidrige, beleidigende, rassistische oder extremistische Inhalte. PORTAL haftet nicht für derartige Verstöße des NUTZERS. Der NUTZER stellt daher PORTAL von allen Ansprüchen Dritter frei, insbesondere solche, die auf einer Verletzung von Urheberrecht, Markenrecht, Wettbewerbsrecht, Medienrecht oder anderen vertraglichen Pflichten von NUTZER entstehen.</li>
                <li><strong>PORTAL überprüft die Angaben über PARTNER, EMPFEHLER und RECO.BONS nicht und übernimmt daher auch keinerlei Gewähr für die Richtigkeit der von dem NUTZER oder PARTNER hinterlegten Angebote, Daten, Qualifikationen, Angaben zur Identität etc.</strong></li>
            </ol>
            <p><strong>§ 10 Geheimhaltung</strong></p>
            <ol>
                <li>Der NUTZER verpflichtet sich, über geheimhaltungsbedürftige Informationen Stillschweigen zu bewahren.</li>
                <li>Von dieser Verpflichtung ausgenommen sind solche Informationen, die
                    <ol type="a">
                        <li>dem NUTZER bereits vorher ohne Verpflichtung zur Geheimhaltung bekannt waren oder</li>
                        <li>allgemein bekannt sind oder werden, ohne dass dies der NUTZER zu vertreten hat oder</li>
                        <li>dem NUTZER von einem Dritten ohne Geheimhaltungsverpflichtung mitgeteilt bzw. überlassen werden oder</li>
                        <li>aufgrund rechtlicher Vorschriften Behörden zugänglich zu machen sind oder </li>
                        <li>von PARTNER oder PORTAL gegenüber dem NUTZER zur Bekanntmachung schriftlich freigegeben worden sind.</li>
                    </ol>
                </li>
            </ol>
            <p><strong>§ 11 Schlussbestimmungen</strong></p>
            <ol>
                <li>Für diese Vereinbarung gilt ausschließlich das Recht der Bundesrepublik Deutschland unter Ausschluss des internationalen Privatrechts sowie unter Ausschluss des UNKaufrechts über den internationalen Warenkauf (CISG).</li>
                <li><strong>Die Europäische Kommission stellt eine Plattform zur Online-Streitbeilegung (OSPlattform) bereit, die Sie hier finden <a class="text-primary" href="ttps://webgate.ec.europa.eu/odr/" target="_blank">https://webgate.ec.europa.eu/odr/</a>. Der NUTZER hat als Verbraucher daher die Möglichkeit, diese OS-Plattform für die Beilegung von Streitigkeiten zu nutzen.</strong></li>
                <li>Sollte eine Bestimmung dieser Nutzungsbedingungen unwirksam sein oder werden, so berührt dies die Gültigkeit der Bestimmungen im Übrigen nicht. Anstelle der unwirksamen Bestimmung gelten die einschlägigen gesetzlichen Vorschriften.</li>
            </ol>
            <p><strong>Stand: 02.01.2017</strong>
        </div>
    </div>
@endsection