<div class="sellerTitle text-center pt-3">{{ $seller->account->company }}</div>
<div class="sellerLogo text-center mt-3">
    <img src="{{ $seller->account->logo }}" />
</div>
<div class="sellerDescription pt-3">
    {!! nl2br(e(trim($seller->account->description))) !!}
</div>
<div class="text-center pt-5 pb-5">
    <div id="sellerShareSmall">
        <div id="sellerShareSmallTitle" class="text-center">
            <span>Empfehle uns jetzt an Deine Freunde! Wir belohnen Dich mit einer <strong>Prämie!</strong></span>
        </div>
        <div id="sellerShareSmallBtnHolder" class="text-center">
            @if(Auth::user())
                <a class="seller-share-btn sellerShareWhatsapp" target="_blank" href="{{ $seller->links->whatsapp }}">
                    <i class="fab fa-whatsapp"></i>
                </a>
                <a class="seller-share-btn sellerShareMail active" href="#" data-share="email" data-entity="seller" data-entity-id="{{ $seller->id }}" data-link="{{ $seller->links->raw }}">
                    <i class="fas fa-at"></i>
                </a>
                <div class="seller-share-btn sellerShareFacebook active" onclick="FB.ui({@if(true === hisorange\BrowserDetect\Facade\Parser::isMobile()) method:'share',href @else method:'send',link @endif:'{{ $seller->links->raw }}}'})">
                    <i class="fab fa-facebook-f"></i>
                </div>
            @else
                <a class="seller-share-btn sellerShareWhatsapp" href="{{ url('/login') }}">
                    <i class="fab fa-whatsapp"></i>
                </a>
                <a class="seller-share-btn sellerShareMail" href="{{ url('/login') }}">
                    <i class="fas fa-at"></i>
                </a>
                <a class="seller-share-btn sellerShareFacebook" href="{{ url('/login') }}">
                    <i class="fab fa-facebook-f"></i>
                </a>
            @endif
            <input id="sellerShareEmailInput" placeholder="E-Mail Vom Freund" />
            <div id="sellerShareEmailSend" class="btn btn-primary"><i class="fas fa-caret-right"></i></div>
        </div>
    </div>
</div>