@extends('redesign.layouts.listeo.front')

@section('title', $seller->account->company)

@section('scripts-page')
    @if ($places->count())
        @include('redesign.front.listeo.pieces.map_init')
    @endif
@endsection

@section('bar')
    @if ( Auth::user() && Auth::user()->hasRole('agent') )
        @include('redesign.front.listeo.pieces.bar_seller')
    @endif
@endsection

@section('document')
    <div id="sellerImage" style="background-image:url({{ asset($seller->account->picture ?? '/account/portraits/business.png') }})"></div>

    <div class="container">
        <div class="row sticky-wrapper">
            <div class="col-lg-8 col-md-8 padding-right-30">

                <div id="sellerInfo">
                    <div id="sellerLogo" style="background-image:url({{ $seller->account->logo }})"></div>
                    <div id="sellerTitle">{{ $seller->account->company }}</div>
                    <div id="sellerAddress"><i class="fa fa-map-marker"></i> {{ $seller->present()->address }}</div>
                </div>

                <div id="titlebar" class="listing-titlebar">
                    <div class="listing-titlebar-logo">
                        <img src="{{ $seller->account->logo }}">
                    </div>
                    <div class="listing-titlebar-title">
                        <h2>{{ $seller->account->company }}</h2>
                        <span>
                            <a href="#listing-location" class="listing-address">
                                <i class="fa fa-map-marker"></i>
                                {{ $seller->present()->address }}
                            </a>
                        </span>
                        @if ($reviewsCount)
                            <div class="star-rating" data-rating="{{ $reviewsAvg }}">
                                <div class="rating-counter"><a href="#listing-reviews">({{ $reviewsCount }} {{ 1 < $reviewsCount ? 'Bewertungen' : 'Bewertung' }})</a></div>
                            </div>
                        @else
                            <div>Keine Bewertungen</div>
                        @endif
                    </div>
                </div>

                <div id="listing-nav" class="listing-nav-container">
                    <ul class="listing-nav">
                        <li><a href="#listing-overview" class="active">Wir sind</a></li>
                        @if ($deals->count())
                        <li><a href="#listing-deals">Kampagnen</a></li>
                        @endif
                        @if ($places->count())
                        <li><a href="#listing-location">Location</a></li>
                        @endif
                        <li><a href="#listing-reviews">Bewertungen</a></li>
                    </ul>
                </div>

                <div id="listing-overview" class="listing-section">
                    {!! nl2br(e(trim($seller->account->description))) !!}
                </div>

                @if ($deals->count())
                    <div id="listing-deals" class="listing-section">
                        <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Kampagnen</h3>

                        <div class="pricing-list-container">
                            <h4>Unsere aktuellen Kampagnen</h4><br>
                        </div>

                        @include('redesign.front.listeo.pieces.deals', ['deals' => $deals])
                    </div>
                @endif

                @if ($places->count())
                    <div id="listing-location" class="listing-section">
                        <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Location</h3>

                        <div id="sellerMapHolder">
                            <div id="map"></div>
                        </div>
                    </div>
                @endif

                <div id="listing-reviews" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-75 margin-bottom-20">Bewertungen @if ($reviewsCount)<span>({{ $reviewsCount }})</span>@endif</h3>

                    @include('redesign.front.listeo.pieces.reviews', ['reviews' => $reviews, 'view' => 'for_seller'])

                    <div class="clearfix"></div>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 margin-top-75 sticky">
                @if($seller->email_verified)
                    <div class="verified-badge margin-bottom-35">
                        <i class="sl sl-icon-check"></i> Geprüfter Anbieter
                    </div>
                @endif

                <div class="boxed-widget">
                    <h3 class="text-center"><i class="sl sl-icon-volume-2"></i> Werde unser Empfehler</h3>
                    <div>
                        <p class="text-center">Erhalte Geld für jede Empfehlung</p>
                        <p class="text-center">Du kannst deinen Freunden einfach und schnell unsere Dienstleistungen empfehlen. Verdiene Prämie für jede erfolgreiche Empfehlung!</p>
                        <ul class="recommend-buttons margin-top-40 margin-bottom-0 text-center">
                            @include('redesign.front.seller.pieces.share_buttons')
                        </ul>
                    </div>
                </div>

                @if ($places->count())
                <div class="boxed-widget opening-hours margin-top-35">
                    <h3><i class="sl sl-icon-clock"></i> Öffnungszeiten</h3>
                    <ul>
                        <li>Montag <span>{{ $places[0]->wt_mon }}</span></li>
                        <li>Dienstag <span>{{ $places[0]->wt_tue }}</span></li>
                        <li>Mittwoch <span>{{ $places[0]->wt_wed }}</span></li>
                        <li>Donnerstag <span>{{ $places[0]->wt_thu }}</span></li>
                        <li>Freitag <span>{{ $places[0]->wt_fri }}</span></li>
                        <li>Samstag <span>{{ $places[0]->wt_sat }}</span></li>
                        <li>Sonntag <span>{{ $places[0]->wt_sun }}</span></li>
                    </ul>
                </div>
                @endif

                @include('redesign.front.listeo.pieces.seller_info', ['seller' => $seller])
            </div>
        </div>
    </div>
@endsection