@extends('redesign.layouts.listeo.front')

@section('title', request('q'))

@section('body-class', 'search-page')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Suchergebnisse für "{{ request('q') }}"</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Suchergebnisse'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div id="listing-deals" class="listing-section">
            @if ($deals->count())
                @include('redesign.front.listeo.pieces.deals', ['deals' => $deals])
            @else
                <div class="notification notice">Tut uns leid. Keine Kampagnen für "{{ request('q') }}" gefunden.</div>
                <h3 class="margin-top-50 margin-bottom-50">Unsere TOP-Kampagnen</h3>
                @include('redesign.front.listeo.pieces.deals', ['deals' => $top])
            @endif
        </div>
    </div>
@endsection