<script async defer src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.key') }}&callback=initGMap"></script>
<script>
    var initGMap = function () {
        var map = new google.maps.Map(
            document.getElementById('gmap'), {
                zoom: 10,
                disableDefaultUI: true
            }
        );
        geocoder = new google.maps.Geocoder();
        codeAddress(geocoder, map);

        function codeAddress(geocoder, map) {
            geocoder.geocode({'address': '{{ $seller->account->street }} {{ $seller->account->housenumber }} {{ $seller->account->zip }} {{ $seller->account->city }}'}, function(results, status) {
                if (status === 'OK') {
                    map.setCenter(results[0].geometry.location);
                    addMarker(results[0].geometry.location, map);
                }
            });
        }

        function addMarker(dot, map) {
            var marker = new google.maps.Marker({
                position: dot,
                map: map,
                animation: google.maps.Animation.DROP,
            });
            var contentString =
                '<div class="mttHolder">' +
                '<div class="mttHeader">{{ $seller->account->company }}</div>' +
                '<div class="mttBody">' +
                '<div class="mttLeft">' +
                '<div class="mttAddress">{{ $seller->account->street }} {{ $seller->account->housenumber }}</br>{{ $seller->account->zip }} {{ $seller->account->city }}<i class="fas fa-map-marker-alt"></i></div>' +
                '<div class="mttPhone">{{ $seller->phone }}<i class="fas fa-phone"></i></div>' +
                '</div>' +
                '<div class="mttRight">' +
                '<div class="mttTimes">' +
                '<div class="mttTime"><span>Mon</span><strong>{{ json_decode($seller->account->worktimes)[0] }}</strong></div>' +
                '<div class="mttTime"><span>Die</span><strong>{{ json_decode($seller->account->worktimes)[1] }}</strong></div>' +
                '<div class="mttTime"><span>Mit</span><strong>{{ json_decode($seller->account->worktimes)[2] }}</strong></div>' +
                '<div class="mttTime"><span>Don</span><strong>{{ json_decode($seller->account->worktimes)[3] }}</strong></div>' +
                '<div class="mttTime"><span>Fre</span><strong>{{ json_decode($seller->account->worktimes)[4] }}</strong></div>' +
                '<div class="mttTime"><span>Sam</span><strong>{{ json_decode($seller->account->worktimes)[5] }}</strong></div>' +
                '<div class="mttTime"><span>Son</span><strong>{{ json_decode($seller->account->worktimes)[6] }}</strong></div>' +
                '<i class="far fa-clock"></i>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>'
            ;
            var infowindow = new google.maps.InfoWindow({
                content: contentString
            });
            marker.addListener('click', function() {
                infowindow.open(map, marker);
            });
        }
    };
</script>