<header>
    <div class="container">
        <nav class="navbar navbar-light bg-white justify-content-between navbar-expand" id="navbarTop">
            <a class="navbar-brand" href="{{ route('home') }}">
                <img id="mainLogo" src="{{ asset('img/logo_200x56.png') }}" />
            </a>
            @if ( config('recoma.openedSystem', false) )
                @include('redesign.front.pieces.search_controls')
            @endif
            <div>
                <ul class="navbar-nav">
                    @if ( config('recoma.openedSystem', false) )
                        <ul class="nav navbar-nav ml-auto d-md-none">
                            <li class="nav-item text-center">
                                <a class="nav-link" href="#" id="searchInputToggler">
                                    <i class="fas fa-search"></i>
                                </a>
                            </li>
                            <li class="nav-item text-center">
                                <a class="nav-link" href="#" id="geoInputToggler">
                                    <i class="fas fa-map-marker-alt"></i>
                                </a>
                            </li>
                        </ul>
                    @endif
                    @if ( !Auth::user() )
                        <li class="nav-item text-center">
                            <a class="nav-link" href="{{ url('/login') }}">
                                <i class="fas fa-sign-in-alt"></i>
                                <span class="d-none d-sm-inline">Anmelden</span>
                            </a>
                        </li>
                    @else
                        <li class="nav-item billing-item text-center d-none d-md-inline-block">
                            <a href="{{ route('user.transactions') }}">
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Ausgezahlt</span>
                                    <span class="billing-item-sum">{{ Format::currency($totals->paid_out) }}</span>
                                </div>
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Offen</span>
                                    <span class="billing-item-sum">{{ Format::currency($totals->pending) }}</span>
                                </div>
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Kontostand</span>
                                    <span class="billing-item-sum @if($totals->allocated) text-success @endif">{{ Format::currency($totals->allocated) }}</span>
                                </div>
                            </a>
                        </li>
                        <li class="nav-item text-center">
                            <a href="{{ route('user.profile') }}">
                                <span class="userpic" style="background-image:url({{ Auth::user()->userpic }})"/>
                            </a>
                        </li>
                    @endif
                </ul>
            </div>
        </nav>
    </div>
</header>