<header>
    <div class="container">
        <nav class="navbar navbar-expand-md navbar-light bg-white justify-content-between" id="navbarTop">
            <a class="navbar-brand" href="{{ route('home') }}">
                <img id="mainLogo" src="{{ asset('img/logo_200x56.png') }}" />
            </a>
            @if ( config('recoma.openedSystem', false) )
                <div class="row flex-grow-1 justify-content-end text-right d-md-none" style="padding-right:30px">
                    <div id="searchInputToggler" class="btn btn-outline">
                        <i class="fas fa-search"></i>
                    </div>
                    <div id="geoInputToggler" class="btn btn-outline">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                </div>
            @endif
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarText" aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            @if ( config('recoma.openedSystem', false) )
                @include('redesign.front.pieces.search_controls')
            @endif
            <div class="collapse navbar-collapse" id="navbarText">
                <ul class="nav navbar-nav ml-auto">
                    @if ( !Auth::user() )
                        <li class="nav-item text-center">
                            <a class="nav-link" href="{{ url('/login') }}">
                                <i class="fas fa-sign-in-alt"></i>
                                <span>Anmelden</span>
                            </a>
                        </li>
                        @if ( config('recoma.openedSystem', false) )
                        <li class="nav-item text-center">
                            <a class="nav-link" href="{{ route('auth.register') }}">Registrieren</a>
                        </li>
                        @endif
                    @else
                        <li class="nav-item text-center dropdown">
                            <a class="nav-link dropdown-toggle" href="{{ route('user.profile') }}" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="d-none d-lg-inline-block">{{ Auth::user()->fullname }}</span>
                                <span class="userpic" style="background-image:url({{ Auth::user()->userpic }})"/>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item" href="{{ route('user.coupons') }}">
                                    <i class="fas fa-ticket-alt"></i>
                                    <span>RECO.BONs</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('user.profile') }}">
                                    <i class="fas fa-user"></i>
                                    <span>Profil</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('user.fav') }}">
                                    <i class="far fa-heart"></i>
                                    <span>Favoriten</span>
                                    <span class="badge badge-pill badge-secondary" id="favsCounter">{{ $favs->count() ? $favs->count() : '' }}</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('user.transactions') }}">
                                    <i class="far fa-credit-card"></i>
                                    <span>Konto</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('user.reviews') }}">
                                    <i class="far fa-star"></i>
                                    <span>Bewertungen</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('user.referrals') }}">
                                    <i class="fas fa-user-friends"></i>
                                    <span>Empfehlungen</span>
                                </a>
                                <a class="dropdown-item" href="{{ route('owngift-list') }}">
                                    <i class="fas fa-gift"></i>
                                    <span>Geschenke</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{ url('logout') }}">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span>Abmelden</span>
                                </a>
                            </div>
                        </li>
                        <li class="nav-item billing-item text-center d-sm-none d-xl-block">
                            <a href="{{ route('user.transactions') }}">
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Ausgezahlt</span>
                                    <span class="billing-item-sum">{{ Format::currency($totals->paid_out) }}</span>
                                </div>
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Offen</span>
                                    <span class="billing-item-sum">{{ Format::currency($totals->pending) }}</span>
                                </div>
                                <div class="billing-item text-center">
                                    <span class="billing-item-title">Kontostand</span>
                                    <span class="billing-item-sum @if($totals->allocated) text-success @endif">{{ Format::currency($totals->allocated) }}</span>
                                </div>
                            </a>
                        </li>
                    @endif
                </ul>
            </div>
        </nav>
    </div>
</header>