<div class="deal">
    <a href="{{ route('deal.index', ['couponTemplate' => $deal]) }}" class="deal-link"></a>
    <div class="deal-body lazyload" style="background-image:url()" data-src="{{ route('coupon.get-image', $deal->img) }}">
        <a class="deal-seller-logo" href="{{ route('seller.index', ['alias' => $deal->seller->alias]) }}">
            <img src="/account/portraits/{{ $deal->seller->account->upload_portrait }}">
        </a>
        <a class="deal-btn deal-fav" href="{{ url('/login') }}">
            <i class="far fa-heart"></i>
            <i class="fas fa-heart"></i>
        </a>
        <a class="deal-btn dealShareBtn" href="{{ url('/login') }}">
            <i class="fas fa-share-alt"></i>
        </a>
        <a class="deal-btn deal-get-cashback dealCashbackBtn" href="{{ url('/login') }}">
            <i class="fas fa-hand-holding-usd"></i>
        </a>
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_discount )
            <div class="deal-cashback-gift">
                <img src="{{ asset($deal->discountGift->image) }}">
            </div>
        @endif
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_provision )
            <div class="deal-provision-gift">
                <img src="{{ asset($deal->provisionGift->image) }}">
            </div>
        @endif
    </div>
    <div class="deal-footer">
        <div class="deal-title">{{ $deal->title }}</div>
        <div class="text-center">
            @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
            <div class="deal-provision">
                <div class="big">{{ $deal->present()->provision_agent_deal }}</div>
                <div class="small">Prämie</div>
                <div class="smallest">für Empfehlung</div>
            </div>
            @endif
            <div class="deal-cashback">
                <div class="big">{{ $deal->present()->discount_consumer_deal }}</div>
                <div class="small">Cashback</div>
                <div class="smallest">für Einkauf</div>
            </div>
        </div>
    </div>
</div>