<div class="deal" data-deal-id="{{ $deal->id }}">
    <a href="{{ route('deal.index', ['couponTemplate' => $deal]) }}" class="deal-link"></a>
    <div class="deal-body lazyload" style="background-image:url()" data-src="{{ route('coupon.get-image', $deal->img) }}">
        <a class="deal-seller-logo" href="{{ route('seller.index', ['alias' => $deal->seller->alias]) }}">
            <img src="/account/portraits/{{ $deal->seller->account->upload_portrait }}">
        </a>
        <div class="deal-btn deal-unfav">
            <i class="fas fa-trash-alt"></i>
        </div>
        <div class="deal-share-holder dealShareHolder">
            <div class="deal-btn deal-share-icon">
                <i class="fas fa-share-alt"></i>
            </div>
            <div class="deal-share-label">via</div>
            <div class="deal-btn deal-share-email dealEmailBtn"><i class="fas fa-at"></i><span>email</span></div>
            <a target="_blank"
               href="{{ route('linkinvitation', ['reason' => 'share-coupon', 'id' => $deal->id, 'type' => 'whatsapp']) }}"
               class="deal-btn deal-share-whatsapp dealWaBtn"
            ><i class="fab fa-whatsapp"></i><span>whatsapp</span></a>
            <a target="_blank"
               href="#"
               class="deal-btn deal-share-facebook dealFbBtn"
            ><i class="fab fa-facebook-f"></i><span>facebook</span></a>
        </div>
        <div class="deal-btn deal-cashback-holder dealCashbackHolder">
            <div class="deal-btn deal-cashback-icon">
                <i class="fas fa-hand-holding-usd"></i>
            </div>
            <div class="deal-btn dealGetCashbackBtn">
                <i class="fas fa-money-bill-alt"></i>
                <span>Cashback erhalten</span>
            </div>
        </div>
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_discount )
            <div class="deal-cashback-gift">
                <img src="{{ asset($deal->discountGift->image) }}">
            </div>
        @endif
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_provision )
            <div class="deal-provision-gift">
                <img src="{{ asset($deal->provisionGift->image) }}">
            </div>
        @endif
    </div>
    <div class="deal-footer">
        <div class="deal-title">{{ $deal->title }}</div>
        <div class="text-center">
            @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
                <div class="deal-provision">
                    <div class="big">{{ $deal->present()->provision_agent_deal }}</div>
                    <div class="small">Prämie</div>
                    <div class="smallest">für Empfehlung</div>
                </div>
            @endif
            <div class="deal-cashback">
                <div class="big">{{ $deal->present()->discount_consumer_deal }}</div>
                <div class="small">Cashback</div>
                <div class="smallest">für Einkauf</div>
            </div>
        </div>
    </div>
</div>