<div class="coupon coupon-sample">
    <div class="coupon-body lazyload" data-src="{{ $deal->mainImage }}">
        <div class="coupon-seller-logo">
            <img src="{{ $deal->seller->account->logo }}">
        </div>
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_discount )
            <div class="coupon-cashback-gift">
                <img src="{{ asset($deal->discountGift->image) }}">
            </div>
        @endif
        @if ( \App\CouponTemplate::TYPE_GIFT === $deal->type_provision )
            <div class="coupon-provision-gift">
                <img src="{{ asset($deal->provisionGift->image) }}">
            </div>
        @endif
    </div>

    <div class="coupon-footer">
        <div class="coupon-title">{{ $deal->title }}</div>
        <div class="text-center">
            @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
                <div class="coupon-provision">
                    <div class="big">{{ $deal->present()->provision_agent_deal }}</div>
                    <div class="small">Prämie</div>
                    <div class="smallest">für Empfehlung</div>
                </div>
            @endif
            <div class="coupon-cashback">
                <div class="big">{{ $deal->present()->discount_consumer_deal }}</div>
                <div class="small">Cashback</div>
                <div class="smallest">für Einkauf</div>
            </div>
        </div>
    </div>

    <div class="coupon-data">
        <div class="coupon-info">{{ $deal->coupon_count }} RECO.BON bis {{ Carbon\Carbon::parse($deal->expiration_date)->format('d.m.Y') }}</div>
        <div class="coupon-barcode">
            <img src="{{ asset('img/barcode_sample.png') }}" />
        </div>
        <div class="coupon-code">vorschau!</div>
    </div>
</div>