<tr class="payoutItem" data-id="{{ $transaction->id }}" data-amount="{{ $transaction->amount }}">
    <td class="payoutsTableSeparateColumn align-middle">{{ $transaction->coupon->template->title }}</td>
    <td class="payoutsTableSeparateColumn align-middle payoutItemCoupon">
        <div class="nobrake">
            <span class="text-monospace">{{ $transaction->coupon->present()->code }}</span>
            <div class="roundBtn showCoupon" data-coupon-id="{{ $transaction->coupon->id }}">
                <i class="fa fa-search"></i>
            </div>
        </div>
    </td>
    <td class="payoutsTableSeparateColumn align-middle payoutItemAmount">{{ Format::currency($transaction->amount) }}</td>
    <td class="payoutsTableSeparateColumn align-middle">
        @if ( Auth::user()->id === $transaction->coupon->consumer->id )
            @if ( null === $transaction->coupon->template->ratingByUser() )
                <a class="button button-rate rateDeal tiped" data-deal-id="{{ $transaction->coupon->template->id }}" data-deal-title="{{ $transaction->coupon->template->title }}" data-tip-content="Muss vor Auszahlung bewertet werden">
                    Jetzt bewerten
                </a>
            @else
                <div style="min-width: 100px" class="nobrake star-rating" data-rating="{{ $transaction->coupon->template->ratingByUser()->rating }}"></div>
            @endif
        @else
            Nicht notwendig
        @endif
    </td>
    <td class="payoutsTableGeneralColumn align-middle">
        <div>RECO.BON: {{ $transaction->coupon->template->title }}</div>
        <div>
            RECO.CODE:
            <div class="nobrake">
                <span class="text-monospace">{{ $transaction->coupon->present()->code }}</span>
                <div class="roundBtn showCoupon" data-coupon-id="{{ $transaction->coupon->id }}">
                    <i class="fa fa-search"></i>
                </div>
            </div>
        </div>
        <div>Betrag: <strong>{{ Format::currency($transaction->amount) }}</strong></div>
        <div>
            Bewertung:
            @if ( Auth::user()->id === $transaction->coupon->consumer->id )
                @if ( null === $transaction->coupon->template->ratingByUser() )
                    <a class="button button-rate rateDeal tiped" data-deal-id="{{ $transaction->coupon->template->id }}" data-deal-title="{{ $transaction->coupon->template->title }}" data-tip-content="Muss vor Auszahlung bewertet werden">
                        Jetzt bewerten
                    </a>
                @else
                    <div style="min-width: 100px" class="nobrake star-rating" data-rating="{{ $transaction->coupon->template->ratingByUser()->rating }}"></div>
                @endif
            @else
                Nicht notwendig
            @endif
        </div>
    </td>
    <td class="align-middle">
        <div class="checkboxes">
            @if ( null === $transaction->coupon->template->ratingByUser() && Auth::user()->id === $transaction->coupon->consumer->id )
                <input disabled type="checkbox" class="payoutCheckbox">
                <label class="disabledLabel">&nbsp;</label>
            @else
                <input type="checkbox" class="payoutCheckbox" id="payoutCheckbox{{ $transaction->id }}" data-id="{{ $transaction->id }}">
                <label for="payoutCheckbox{{ $transaction->id }}">&nbsp;</label>
            @endif
        </div>
    </td>
</tr>