<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.key') }}"></script>
<script type="text/javascript" src="{{ asset('listeo/scripts/infobox.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('listeo/scripts/markerclusterer.js') }}"></script>
<script>
    function wTime(day, time) {
        if (time.length) {
            return '<p>' + day + ': ' + time + '</p>'
        } else {
            return '';
        }
    };

    function locationData(data) {
        data.phone = data.phone || '';
        data.email = data.email || '';
        return(
            '<div class="listing-content">' +
                '<div class="listing-title">' +
                    '<p>' + data.zip + ' ' + data.city + '</p>' +
                    '<p>' + data.street + ', ' + data.housenumber + '</p>' +
                    '<p>' + data.phone + '</p>' +
                    '<p>' + data.email + '</p>' +
                '</div>' +
                '<div class="listing-times">' +
                    wTime('Montag', data.wt_mon) +
                    wTime('Dienstag', data.wt_tue) +
                    wTime('Mittwoch', data.wt_wed) +
                    wTime('Donnerstag', data.wt_thu) +
                    wTime('Freitag', data.wt_fri) +
                    wTime('Samstag', data.wt_sat) +
                    wTime('Sonntag', data.wt_sun) +
                '</div>' +
            '</div>'
        );
    }
    var locations = [
        @foreach($places as $place)
        [ locationData({!! json_encode($place) !!}), {{ $place->lat }}, {{ $place->lon }}, 0, '<i class="im im-icon-Map-Marker2"></i>'],
        @endforeach
    ];
</script>
<script type="text/javascript" src="{{ asset('listeo/scripts/maps.js') }}"></script>