<div class="col-lg-12 col-md-12 deal {{ isset($class) ? $class : '' }}" data-deal-id="{{ $deal->id }}">
    <div class="listing-item-container list-layout">
        <div class="listing-item">
            <div class="listing-item-image">
                <a href="{{ route('deal.index', ['couponTemplate' => $deal, 'alias' => $deal->seller->alias]) }}"></a>
                <img src="{{ $deal->mainImage }}" alt="">
                @if(0)
                    <span class="tag">{{ $deal->category->name }}</span>
                @endif
            </div>

            <div class="listing-item-content">
                <h3>
                    <a href="{{ route('deal.index', ['couponTemplate' => $deal, 'alias' => $deal->seller->alias]) }}">
                        {{ $deal->title }}
                        @if($deal->distance)
                            &nbsp;({{ $deal->present()->distance }})
                        @endif
                    </a>
                </h3>

                <div class="listing-item-inner">
                    <a href="{{ route('deal.index', ['couponTemplate' => $deal, 'alias' => $deal->seller->alias]) }}">
                        <span><strong>{{ $deal->present()->discount_consumer_deal }}</strong> Cashback für Einkauf</span>
                        @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
                            <br>
                            <span><strong>{{ $deal->present()->provision_agent_deal }}</strong> Prämie für Empfehlung</span>
                        @endif
                    </a>
                </div>

                @include('redesign.front.listeo.pieces.deal.pieces.sharetoggler_btn')

                @include('redesign.front.listeo.pieces.deal.pieces.share_btns')

                @include('redesign.front.listeo.pieces.deal.pieces.cashback_btn')
            </div>
        </div>

        @if ( Request::url() === route('user.fav') )
            <span class="deal-fav like-icon"></span>
        @elseif ( Auth::user() )
            <span class="deal-fav like-icon @if( $deal->isFavorited() ) liked @endif"></span>
        @else
            <span class="deal-fav like-icon disabled showlogin"></span>
        @endif

        <div class="deal-link">
            <a href="{{ route('deal.index', ['couponTemplate' => $deal, 'alias' => $deal->seller->alias]) }}">
                <span>Zur Kampagne</span> <i class="fa fa-external-link"></i>
            </a>
        </div>
    </div>
</div>