<div class="coupon-widget couponItem" style="background-image: url({{ $coupon->mainImage }});">
    <div class="coupon-top">
        <a href="{{ route('coupon.print', ['coupon' => $coupon]) }}" target="_blank" class="coupon-print-icon"></a>
        <div class="coupon-qrcode-icon couponQRCodeBtn"></div>
        <div class="coupon-seller-logo-holder">
            <a class="coupon-seller-logo" href="{{ route('seller.index', ['alias' => $coupon->template->seller->alias]) }}">
                <img src="{{ $coupon->template->seller->account->logo }}">
            </a>
        </div>
        <h3>{{ $coupon->title }}</h3>
        <div class="coupon-valid-untill">
            @if (Auth::id() === $coupon->agent_user_id && Auth::id() !== $coupon->consumer_user_id && \App\Coupon::STATUS_ACTIVE === $coupon->status)
                <span>{{ \App\Coupon::STATUS_TITLES['recommended'] }}</span>
            @else
                <span>{{ \App\Coupon::STATUS_TITLES[$coupon->status] }}</span>
            @endif
        </div>
        <div class="coupon-how-to-use">
            <span><strong>{{ $coupon->present()->discount_consumer_coupon }}</strong> Cashback für Einkauf</span>
            @if ( \App\CouponTemplate::TYPE_NONE !== $coupon->type_provision )
                <br>
                <span><strong>{{ $coupon->present()->provision_agent_coupon }}</strong> Prämie für Empfehlung</span>
            @else
                <br><span>&nbsp;</span>
            @endif
        </div>
    </div>
    <div class="coupon-bottom">
        <div class="coupon-code barcode-holder">
            <span class="coupon-textcode">{{ $coupon->code }}</span>
        </div>
    </div>
    <div class="coupon-qrcode-holder couponQRCodeHolder">
        <div class="coupon-qrcode-close-icon couponQRCloseBtn"></div>
        <img src="{{ $coupon->qrcode }}" />
    </div>
</div>