@extends('redesign.layouts.listeo.front')

@section('body-class', 'front page-fav')

@section('title', 'Favoriten')

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>Favoriten</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => 'Favoriten'])
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                @if ( $favs->count() )
                    @include('redesign.front.listeo.pieces.deals', ['deals' => $favs, 'template' => 'fav'])
                @else
                    <h3 class="margin-bottom-100">Du hast noch keine Favoriten hinzugefügt</h3>
                @endif
            </div>
        </div>
    </div>

    <form id="dealUnfavForm" method="post" action="" class="d-none">
        {{ csrf_field() }}
    </form>
@endsection

@section('scripts-page')
    <script>
        $(document).ready(function () {
            var unfav = function (dealId) {
                $('#dealUnfavForm').attr('action', '/unfav/' + dealId).submit();
            };

            $('.deal-unfav').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                var dealId = $(this).closest('.deal').data('deal-id');

                swal({
                    title: 'Bist du sicher?',
                    text: 'Sie können das nicht rückgängig machen!',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Löschen',
                    cancelButtonText: 'Nein',
                }).then((result) => {
                    if (result.value) {
                        unfav(dealId);
                    }
                });
            });
        });
    </script>
@endsection