<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google_maps.key') }}"></script>
<script type="text/javascript" src="{{ asset('listeo/scripts/infobox.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('listeo/scripts/markerclusterer.js') }}"></script>
<script>
    var locations = [
        @foreach ($deals as $deal)
        [
            '<a href="{{ route('deal.index', ['couponTemplate' => $deal, 'alias' => $deal->seller->alias]) }}" class="listing-img-container">' +
                '<div class="infoBox-close"><i class="fa fa-times"></i></div>' +
                '<img src="{{ $deal->mainImage }}" alt="">' +
                '<div class="listing-item-content">' +
                    '<h3>{{ $deal->title }}</h3>' +
                    '<span>bei <strong>{{ $deal->seller->account->company }}</strong></span>' +
                '</div>' +
            '</a>' +
            '<div class="listing-content">' +
                '<div class="listing-title">' +
                    '<span><strong>{{ $deal->present()->discount_consumer_deal }}</strong> Cashback für Einkauf</span>' +
                    @if ( \App\CouponTemplate::TYPE_NONE !== $deal->type_provision )
                        '<br><br>' +
                        '<span><strong>{{ $deal->present()->provision_agent_deal }}</strong> Prämie für Empfehlung</span>' +
                    @endif
                '</div>' +
            '</div>',
            {{ $deal->lat }},
            {{ $deal->lon }},
            0,
            '<i class="im im-icon-Map-Marker2"></i>'
        ],
        @endforeach
    ];
</script>
<script type="text/javascript" src="{{ asset('listeo/scripts/maps.js') }}"></script>

