@extends('redesign.layouts.listeo.front')

@section('title', $title)

@section('scripts-page')
    @if ( $deals->count() && $geoLocationFilter )
        @include('redesign.front.deals.pieces.deals_map', ['deals' => $deals])
    @endif
@endsection

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>{{ $title }}</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => $title])
                </div>
            </div>
        </div>
    </div>

    @if ( $deals->count() && $geoLocationFilter )
        <div id="dealsMapHolder">
            <div id="map"></div>
        </div>
    @endif

    <div class="container">
        @if ( $deals->count() )
            <div class="margin-bottom-25">
                <div class="col">
                    <div class="fullwidth-filters">
                        @include('redesign.front.pieces.sorting', ['sortings' => $sortings])
                    </div>
                </div>
            </div>
        @endif

        <div id="listing-deals" class="listing-section">
            @if ( $deals->count() )
                @include('redesign.front.listeo.pieces.deals', ['deals' => $deals])
            @else
                <div class="notification notice">Tut uns leid. Keine Kampagnen gefunden.</div>
                <h3 class="margin-top-50 margin-bottom-50">Unsere TOP-Kampagnen</h3>
                @include('redesign.front.listeo.pieces.deals', ['deals' => $top])
            @endif
        </div>
    </div>
@endsection