@extends('redesign.layouts.listeo.front')

@section('body-class', 'front page-deal')

@section('title', $deal->title . ' bei ' . $deal->seller->account->company)

@section('scripts-page')
    @if ($places->count())
        @include('redesign.front.listeo.pieces.map_init')
    @endif
@endsection

@section('bar')
    @if ( Auth::user() && Auth::user()->hasRole('agent') )
        @include('redesign.front.listeo.pieces.bar_deal')
    @endif
@endsection

@section('document')
    @if( $deal->gallery->count() > 1 )
        <div class="listing-slider mfp-gallery-container margin-bottom-0">
            @foreach($deal->gallery as $k => $item)
            <a href="{{ $item->getUrl() }}" data-background-image="{{ $item->getUrl() }}" class="item mfp-gallery"></a>
            @endforeach
        </div>
    @else
        <div id="dealImage" style="background-image:url({{ $deal->mainImage }})"></div>
    @endif

    <div class="container">
        <div class="row sticky-wrapper">
            <div class="col-lg-8 col-md-8 padding-right-30">
                <div class="mobile-visible">
                    @include('redesign.front.listeo.pieces.coupon.fake', ['deal' => $deal])
                </div>

                <div id="sellerInfo">
                    <div id="sellerLogo" style="background-image:url({{ $deal->seller->account->logo }})"></div>
                    <div id="sellerTitle">{{ $deal->seller->account->company }}</div>
                    <div id="sellerAddress"><i class="fa fa-map-marker"></i> {{ $deal->seller->present()->address }}</div>
                </div>

                <div id="titlebar" class="listing-titlebar">
                    <div class="listing-titlebar-title">
                        <h2>{{ $deal->title }} <span class="listing-tag">{{ $deal->category->name }}</span></h2>
                        <span>
                            <a href="#listing-location" class="listing-address">
                                <i class="fa fa-map-marker"></i>
                                {{ $deal->seller->present()->address }}
                            </a>
                        </span>
                        @if ($reviewsCount)
                            <div class="star-rating" data-rating="{{ $reviewsAvg }}">
                                <div class="rating-counter"><a href="#listing-reviews">({{ $reviewsCount }} {{ 1 < $reviewsCount ? 'Bewertungen' : 'Bewertung' }})</a></div>
                            </div>
                        @else
                            <div>Noch keine Bewertungen</div>
                        @endif
                    </div>
                </div>

                <div class="verified-badge mobile-visible margin-bottom-30">
                    <i class="sl sl-icon-check"></i> Geprüfter Anbieter
                </div>

                <div id="listing-nav" class="listing-nav-container mobile-invisible">
                    <ul class="listing-nav">
                        @if ($deal->description)
                            <li><a href="#listing-description">Beschreibung</a></li>
                        @endif

                        @if ($deal->terms)
                            <li><a href="#listing-terms">Bedingungen</a></li>
                        @endif

                        @if ($places->count())
                            <li><a href="#listing-location">Location</a></li>
                        @endif

                        <li><a href="#listing-reviews">Bewertungen</a></li>

                        @if ( $otherDeals->count() )
                            <li><a href="#listing-deals">Andere Kampagnen</a></li>
                        @endif
                    </ul>
                </div>

                @if ($deal->description)
                    <div id="listing-description" class="listing-section">
                        {!! nl2br(e(trim($deal->description))) !!}

                        <div class="listing-links-container">
                            <ul class="listing-links contact-links">
                                @if($deal->seller->phone)
                                    <li><a href="tel:{{ $deal->seller->phone }}" class="listing-links"><i class="fa fa-phone"></i> {{ $deal->seller->phone }}</a></li>
                                @endif
                                @if($deal->seller->account->email)
                                    <li><a href="mailto:{{ $deal->seller->account->email }}" class="listing-links"><i class="fa fa-envelope-o"></i> {{ $deal->seller->account->email }}</a>
                                @endif
                            </ul>
                            <div class="clearfix"></div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                @endif

                @if ($deal->terms)
                    <div id="listing-terms" class="listing-section">
                        <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Bedingungen</h3>

                        {!! nl2br(e(trim($deal->terms))) !!}
                    </div>
                @endif

                @if ($places->count())
                    <div id="listing-location" class="listing-section">
                        <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Location</h3>

                        <div id="sellerMapHolder">
                            <div id="map"></div>
                        </div>
                    </div>
                @endif

                @if ($places->count())
                    <div class="boxed-widget opening-hours margin-top-35 mobile-visible">
                        <h3><i class="sl sl-icon-clock"></i> Öffnungszeiten</h3>
                        <ul>
                            <li>Montag <span>{{ $places[0]->wt_mon }}</span></li>
                            <li>Dienstag <span>{{ $places[0]->wt_tue }}</span></li>
                            <li>Mittwoch <span>{{ $places[0]->wt_wed }}</span></li>
                            <li>Donnerstag <span>{{ $places[0]->wt_thu }}</span></li>
                            <li>Freitag <span>{{ $places[0]->wt_fri }}</span></li>
                            <li>Samstag <span>{{ $places[0]->wt_sat }}</span></li>
                            <li>Sonntag <span>{{ $places[0]->wt_sun }}</span></li>
                        </ul>
                    </div>
                @endif

                <div id="listing-reviews" class="listing-section">
                    <h3 class="listing-desc-headline margin-top-75 margin-bottom-20">Bewertungen @if ($reviewsCount)<span>({{ $reviewsCount }})</span>@endif</h3>

                    @include('redesign.front.listeo.pieces.reviews', ['reviews' => $reviews, 'view' => 'for_deal'])

                    <div class="clearfix"></div>
                </div>

                @if ( $otherDeals->count() )
                    <div id="listing-deals" class="listing-section">
                        <h3 class="listing-desc-headline margin-top-60 margin-bottom-30">Andere Kampagnen</h3>

                        @include('redesign.front.listeo.pieces.deals', ['deals' => $otherDeals])
                    </div>
                @endif
            </div>

            <div class="col-lg-4 col-md-4 margin-top-75 sticky">
                <div class="verified-badge mobile-invisible margin-bottom-30">
                    <i class="sl sl-icon-check"></i> Geprüfter Anbieter
                </div>

                <div class="mobile-invisible">
                    @include('redesign.front.listeo.pieces.coupon.fake', ['deal' => $deal])
                </div>

                <div class="boxed-widget margin-top-35 mobile-invisible">
                    <h3 class="text-center"><i class="sl sl-icon-volume-2"></i> Werde unser Empfehler</h3>
                    <div>
                        <p class="text-center">Erhalte Geld für jede Empfehlung</p>
                        <p class="text-center">Du kannst deinen Freunden einfach und schnell unsere Dienstleistungen empfehlen. Verdiene Prämie für jede erfolgreiche Empfehlung!</p>
                        <ul class="recommend-buttons margin-top-40 margin-bottom-0 text-center">
                            @include('redesign.front.deal.pieces.share_buttons')
                        </ul>
                        <div class="text-center">
                            <span>oder</span>
                            @if ( Auth::user() && Auth::user()->hasRole('agent') )
                                <a href="#" class="button book-now fullwidth margin-top-5 dealGetCashbackBtn" data-deal-id="{{ $deal->id }}">Cashback erhalten</a>
                            @else
                                <a href="#" class="button book-now fullwidth margin-top-5 showlogin">Cashback erhalten</a>
                            @endif
                        </div>
                    </div>
                </div>

                @if ($places->count())
                    <div class="boxed-widget opening-hours margin-top-35 mobile-invisible">
                        <h3><i class="sl sl-icon-clock"></i> Öffnungszeiten</h3>
                        <ul>
                            <li>Montag <span>{{ $places[0]->wt_mon }}</span></li>
                            <li>Dienstag <span>{{ $places[0]->wt_tue }}</span></li>
                            <li>Mittwoch <span>{{ $places[0]->wt_wed }}</span></li>
                            <li>Donnerstag <span>{{ $places[0]->wt_thu }}</span></li>
                            <li>Freitag <span>{{ $places[0]->wt_fri }}</span></li>
                            <li>Samstag <span>{{ $places[0]->wt_sat }}</span></li>
                            <li>Sonntag <span>{{ $places[0]->wt_sun }}</span></li>
                        </ul>
                    </div>
                @endif

                @include('redesign.front.listeo.pieces.seller_info', ['seller' => $deal->seller, 'deal' => $deal])
            </div>
        </div>
    </div>
@endsection