@extends('redesign.layouts.listeo.front')

@section('body-class', 'category-page')

@section('title', $category->name)

@section('document')
    <div id="titlebar">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h4>{{ $category->name }}</h4>
                    @include('redesign.front.listeo.pieces.breadcrumbs', ['current' => $category->name])
                </div>
            </div>
        </div>
    </div>

    @if ( $subcategories && $subcategories->count() )
        <div class="container">
            <div class="toggle-wrap">
                <span class="trigger"><a href="#">{{ $category->name }} subkategorien<i class="sl sl-icon-plus"></i></a></span>
                <div class="toggle-container" style="display: none;">
                    @include('redesign.front.category.pieces.subcategories', ['items' => $subcategories])
                </div>
            </div>
        </div>
    @endif

    <div class="container">
        @if ( $deals->count() )
            <div class="margin-bottom-25">
                <div class="col">
                    <div class="fullwidth-filters">
                        @include('redesign.front.pieces.sorting', ['sortings' => $sortings])
                    </div>
                </div>
            </div>
        @endif

        <div id="listing-deals" class="listing-section">
            @if ( $deals->count() )
                @include('redesign.front.listeo.pieces.deals', ['deals' => $deals])
            @else
                <div class="notification notice">Es gibt noch keine Kampagnen in dieser Kategorie.</div>
                <h3 class="margin-top-50 margin-bottom-50">Unsere TOP-Kampagnen</h3>
                @include('redesign.front.listeo.pieces.deals', ['deals' => $top])
            @endif
        </div>
    </div>
@endsection