@extends('redesign.layouts.landing')

@section('title', 'Für Unternehmen')

@section('document')
    @include('redesign.pieces.landing.header')

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <div class="l-section pt-2 pt-sm-5 pb-5">
            <div class="text-center">
                <div class="l-subheading mb-2">Neukunden durch <strong>Empfehlungen</strong></div>
                <div class="l-text mb-2">Durch unser Empfehlungsportal wird Ihr Unternehmen</div>
                <div>
                    <a class="btn btn-primary btn-lg text-white" href="{{ route('auth.register-seller') }}">Unternehmen registrieren</a>
                </div>
            </div>
        </div>
        <div class="text-center">
            <img src="{{ asset('img/landing/business/img1.png') }}" />
        </div>
    </section>

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <div id="advCarousel" class="carousel slide pt-3 pb-3" data-ride="carousel">
            <div class="carousel-inner text-center">
                <div class="carousel-item active">9 von 10 Menschen vertrauen auf die Empfehlung eines Freundes</div>
                <div class="carousel-item">96% aller Menschen ignorieren Ihre Werbung</div>
                <div class="carousel-item">Weltweit werden täglich 2,4 Milliarden Empfehlungen ausgesprochen</div>
                <div class="carousel-item">Ihre Kunden geben durch Empfehlung doppelt so viel aus</div>
                <div class="carousel-item">Jeder zweite Kunde empfiehlt Sie, wenn er belohnt wird</div>
                <div class="carousel-item">Profitieren Sie endlich von der Empfehlung Ihrer Kunden</div>
            </div>
            <a class="carousel-control-prev" href="#advCarousel" role="button" data-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="carousel-control-next" href="#advCarousel" role="button" data-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
    </section>

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <div class="l-section pt-2 pt-sm-5 pb-5">
            <div class="text-center">
                <div class="l-subheading mb-2">Empfehlungen verkaufen viel einfacher.</div>
                <div class="l-text mb-2">Der einfachste Weg zu potentiellen Kunden sind Empfehlungen
                    Mit RECO.MA sind Sie immer eine gute Empfehlung voraus!</div>
            </div>
            <div class="row text-center mt-5 mt-sm-5 nogutters">
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/alle-vorteile/sales-increase.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">Steigern Sie Ihre Umsätze</div>
                    <div class="l-desc mt-2">Durch unser Empfehlungsmarketing Netzwerk können Sie Ihre Umsätze steigern. Laden Sie ihre Kunden, Bekannten und Freunde ein, damit diese Sie bei einer passenden Gelegenheit empfehlen können und machen Sie Ihre gewonnenen Kunden auch zu Empfehlern.</div>
                </div>
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/alle-vorteile/binoculars.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">Haben Sie alles Im Blick</div>
                    <div class="l-desc mt-2">Sie sehen jederzeit und überall, wenn Sie empfohlen werden. Gleichzeitig bietet Ihnen unser Auswertungssystem alle Kennzahlen, um Ihr Empfehlungsmarketing zu verbessern und so noch mehr Kunden zu gewinnen.</div>
                </div>
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/alle-vorteile/reduce-costs.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">Senken Sie Ihre Ausgaben</div>
                    <div class="l-desc mt-2">Nie konnten Sie günstiger auf sich aufmerksam machen. Vergessen Sie uneffiziente Print-, Online- oder TV-Werbung. Setzten Sie auf Empfehlungen, die erfolgreichste Werbemethode seit es den Handel gibt. Und das alles für weniger als eine Tasse Kaffe am Tag.</div>
                </div>
            </div>
        </div>
    </section>

    <section class="l-line">
        <div class="l-section pt-3 pb-3 text-center">
            Erfahren Sie in unserem <strong>kostenlosem eBook</strong>, wie Sie von jedem Kunden empfohlen werden.
        </div>
    </section>

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <a name="how"></a>
        <div class="l-section pt-2 pt-sm-5 pb-5">
            <div class="text-center">
                <div class="l-subheading mb-2">So funktioniert RECO.MA</div>
                <div class="l-text mb-2">Ganz einfach in nur 3 Schritten mit RECO.MA durchstarten!</div>
            </div>
            <div class="row text-center mt-0 mt-sm-5 nogutters">
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/landingpages/network-built.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">1. NETZWERK AUFBAUEN</div>
                    <div class="l-desc mt-2">Laden Sie Ihre Kunde, Freunde und Bekannte als Empfehler ein.</div>
                </div>
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/landingpages/create-recobon.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">2. RECO.BON ERSTELLEN</div>
                    <div class="l-desc mt-2">Erstellen Sie einen Gutschein, damit Ihr Netzwerk Sie empfehlen kann.</div>
                </div>
                <div class="col-12 col-md-4 mt-5 mt-sm-0">
                    <img src="{{ asset('img/landingpages/get-recommendation.svg') }}" style="width: 120px; height: 120px">
                    <div class="l-title mt-5">3. EMPFHELUNG ERHALTEN</div>
                    <div class="l-desc mt-2">Ihr Unternehmen wird empfohlen und Sie steigern den Umsatz.</div>
                </div>
            </div>
            <div class="text-center mt-4">
                <a class="btn btn-primary btn-lg text-white" href="{{ route('auth.register-seller') }}">Unternehmen registrieren</a>
            </div>
        </div>
    </section>

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <div class="l-section pt-2 pt-sm-5 pb-5">
            <div class="col-12 text-center">
                <div class="l-subheading mb-2">Empfehlungen neu erfunden</div>
                <div class="l-text mb-2">Neukundenakquise wird immer schwieriger.
                    Klassische Werbung wird ignoriert oder weggeklickt, Branchenbücher und Google
                    überschwemmen Ihre potentiellen Neukunden mit Informationen.
                    Eine gute Empfehlung ist der schnellste Weg zu einem Neukunden.
                    Mit RECO.MA können Sie Ihre Bestandskunden
                    durch eine von Ihnen bestimmte Provision zum Weiterempfehlen motivieren.
                    Diese werden Sie jederzeit und überall per E-Mail, Facebook und Whatsapp empfehlen.
                    Und das Beste – Der Interessent hat die Empfehlung in seinem Smartphone immer bei sich!</div>
            </div>
            <div class="row text-center mt-5 mb-5 nogutters d-none d-sm-flex">
                <div class="col-12 col-md-4 mt-4 mt-sm-0">
                    <img src="{{ asset('img/landing/business/email.png') }}" style="width: 120px; height: 120px">
                </div>
                <div class="col-12 col-md-4 mt-4 mt-sm-0">
                    <img src="{{ asset('img/landing/business/wh.png') }}" style="width: 120px; height: 120px">
                </div>
                <div class="col-12 col-md-4 mt-4 mt-sm-0">
                    <img src="{{ asset('img/landing/business/fb.png') }}" style="width: 120px; height: 120px">
                </div>
            </div>
            <div class="text-center mt-4">
                <a class="btn btn-primary btn-lg text-white" href="{{ route('auth.register-seller') }}">Unternehmen registrieren</a>
            </div>
        </div>
    </section>

    <section class="pt-0 pb-0 pt-sm-5 pb-sm-5">
        <div class="l-section pt-2 pt-sm-5 pb-5">
            <div class="col-12 text-center">
                <div class="l-subheading mb-2">Haben Sie noch Fragen? <strong>Wir können helfen?</strong></div>
                <div class="l-text mb-2">Ob technische oder allgemeine Fragen, unser Support ist jederzeit für Sie da! Erreichen Sie uns telefonisch unter
                    0800 2888444 oder nutzen Sie einfach unser Kontaktformular.
                </div>
            </div>
        </div>
    </section>

    @include('redesign.pieces.landing.footer')
@endsection