<div class="card card-back shadow p-2 text-center ">
    <div class="card-header">Empfehlung Widget</div>
    <div class="card-body">
        <div class="alert alert-info">
            <h5 class="alert-heading">Hinweis</h5><hr>
            Wählen Sie eine Ihrer Kampagnen aus um noch mehr Reichweite zu generieren indem Sie ein Widget auf Ihrer Seite platzieren. Diese Widget wird auf jeder Seite Ihrer Hompage platziert. Besucher können Ihr Unternehmen und das Produkt direkt aus diesem Widget heraus empfehlen. Dazu muss nur dieses Script in den bestehenden Code Ihrer Seite eingebettet werden. Gerne helfen wir bei der Umsetzung. Sprechen Sie uns gerne an.
        </div>

        <div class="alert alert-light">
            <h5 class="alert-heading">Widget Kampagne</h5><hr>
            <form class="form-horizontal" action="{{ route('save-invite-widget-options', ['user' => $user]) }}" method="post">
                {{ csrf_field() }}
                <div class="form-group{{ $errors->has('deal') ? ' has-error' : '' }}">
                    <div class="col-12 text-left">
                        @foreach($deals as $deal)
                            <div class="custom-control custom-radio mb-2">
                                <input type="radio" id="deal_{{ $deal->id }}" name="deal" class="custom-control-input" value="{{ $deal->id }}" @if( isset($options['invite.deal_id']) && $deal->id === (int)$options['invite.deal_id']->value ) checked @endif>
                                <label class="custom-control-label" for="deal_{{ $deal->id }}">
                                    {{ $deal->title }} (<strong>{{ $deal->present()->provisionAgent }}</strong> Provision für Empfehlung, <strong>{{ $deal->present()->discountConsumer }}</strong> Cashback für Einkauf)
                                </label>
                            </div>
                        @endforeach

                        @include('partials.form.error', ['property' => 'deal'])
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Speichern
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <div class="alert alert-success">
            <h5 class="alert-heading">Code</h5><hr>
            <span id="widgetInviteCode">{{ $widgetInviteCode }}</span>
            <div class="clipboard widgetCodeCopy" id="widgetInviteCodeCopy" data-toggle="tooltip" data-placement="top" title="" data-clipboard-target="#widgetInviteCode" data-original-title="in die Zwischenablage kopieren">
                <i class="far fa-copy"></i>
            </div>
        </div>
    </div>
    <div class="card-footer">
        <a class="btn btn-primary" href="{{ route('seller.widgets.preview.invite') }}" target="_blank">
            <i class="fas fa-eye"></i> Vorschau
        </a>
    </div>
</div>