<div class="card card-back shadow p-2 text-center">
    <div class="card-header">Widgets Farben</div>
    <form class="form-horizontal" action="{{ route('save-global-widget-options', ['user' => $user]) }}" method="post">
        <div class="card-body">
            <div class="row align-items-end">
                {{ csrf_field() }}

                <div class="col-12 col-md-6 col-xl-3 form-group{{ $errors->has('main_bg') ? ' has-error' : '' }}">
                    <label class="col-12 control-label" for="main_bg">Hauptfarbe (Rahmen, Knopfe Hintergrund)</label>
                    <div class="col-12">
                        <input type="color"
                               id="main_bg"
                               name="main_bg"
                               value="{{ old('main_bg', $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg')) }}"
                        >
                        <input type="text"
                               data-helpto="#main_bg"
                               class="color-picker-helper form-control d-inline-block"
                               pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                               maxlength="7"
                               value="{{ old('main_bg', $options['widgets.colors.main_bg']->value ?? config('widgets.colors.main_bg')) }}"
                        >
                    </div>

                    @include('partials.form.error', ['property' => 'main_bg'])
                </div>

                <div class="col-12 col-md-6 col-xl-3 form-group{{ $errors->has('main_txt') ? ' has-error' : '' }}">
                    <label class="col-12 control-label" for="main_txt">Textfarbe</label>
                    <div class="col-12">
                        <input type="color"
                               id="main_txt"
                               name="main_txt"
                               value="{{ old('main_txt', $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt')) }}"
                        >
                        <input type="text"
                               data-helpto="#main_txt"
                               class="color-picker-helper form-control d-inline-block"
                               pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                               maxlength="7"
                               value="{{ old('main_txt', $options['widgets.colors.main_txt']->value ?? config('widgets.colors.main_txt')) }}"
                        >
                    </div>

                    @include('partials.form.error', ['property' => 'main_txt'])
                </div>

                <div class="col-12 col-md-6 col-xl-3 form-group{{ $errors->has('main_bg_h') ? ' has-error' : '' }}">
                    <label class="col-12 control-label" for="main_bg_h">Hauptfarbe (Hover)</label>
                    <div class="col-12">
                        <input type="color"
                               id="main_bg_h"
                               name="main_bg_h"
                               value="{{ old('main_bg_h', $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h')) }}"
                        >
                        <input type="text"
                               data-helpto="#main_bg_h"
                               class="color-picker-helper form-control d-inline-block"
                               pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                               maxlength="7"
                               value="{{ old('main_bg_h', $options['widgets.colors.main_bg_h']->value ?? config('widgets.colors.main_bg_h')) }}"
                        >
                    </div>

                    @include('partials.form.error', ['property' => 'main_bg_h'])
                </div>

                <div class="col-12 col-md-6 col-xl-3 form-group{{ $errors->has('main_txt_h') ? ' has-error' : '' }}">
                    <label class="col-12 control-label" for="main_txt_h">Textfarbe (Hover)</label>
                    <div class="col-12">
                        <input type="color"
                               id="main_txt_h"
                               name="main_txt_h"
                               value="{{ old('main_txt_h', $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h')) }}"
                        >
                        <input type="text"
                               data-helpto="#main_txt_h"
                               class="color-picker-helper form-control d-inline-block"
                               pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"
                               maxlength="7"
                               value="{{ old('main_txt_h', $options['widgets.colors.main_txt_h']->value ?? config('widgets.colors.main_txt_h')) }}"
                        >
                    </div>

                    @include('partials.form.error', ['property' => 'main_txt_h'])
                </div>
            </div>
        </div>
        <div class="card-footer">
            <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Speichern</button>
        </div>
    </form>
</div>