@extends('redesign.layouts.dashboard')

@section('title', 'Widgets')

@section('documentTitle', 'Widgets')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if ( !$deals->count() )
            <div class="row text-center">
                <div class="col-12">
                    <div class="alert alert-danger">
                        <p>Widgets können erst funktionieren, wenn Sie keine aktiven Deals haben.</p>
                        <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                            <i class="fas fa-plus-circle"></i> Neuen Deal erstellen
                        </a>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-12">
                @include('redesign.back.seller.widgets.pieces.colors')
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.widgets.pieces.invite_widget')
            </div>
            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.widgets.pieces.deals_widget')
            </div>
        </div>
    </div>
@endsection

@section('scripts-page')
    <script>
        $(document).ready(function () {
            $('input[type="color"]').on('change', function () {
                var id = '#' + $(this).attr('id');
                $('input[data-helpto="' + id + '"]').val($(this).val());
            });

            $('input[data-helpto]').on('keyup change', function () {
                var id = $(this).data('helpto');
                $(id).val($(this).val());
            });
        });
    </script>
@endsection