<div class="modal" tabindex="-1" role="dialog" id="t{{ $transaction->first()->id }}">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $transaction->first()->coupon->present()->code  }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-borderless">
                    <thead>
                    </thead>
                    <tbody>
                    <tr>
                        <td>RECO.BON</td>
                        <td><span class="text-monospace">{{ $transaction->first()->coupon->present()->code }}</span></td>
                    </tr>
                    <tr>
                        <td>Kunde</td>
                        <td>
                            <div class="transactionUserPic" style="background-image:url('{{ $transaction->first()->coupon->consumer->userpic }}')"></div>
                            <span>{{ $transaction->first()->coupon->consumer->fullname }}</span>
                        </td>
                    </tr>
                    <tr>
                        <td>Empfehler</td>
                        <td>
                            <div class="transactionUserPic" style="background-image:url('{{ $transaction->first()->coupon->agent->userpic }}')"></div>
                            <span>{{ $transaction->first()->coupon->agent->fullname }}</span>
                        </td>
                    </tr>
                    <tr>
                        <td>Gebühr</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_OPERATOR_PROVISION_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>Cashback</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_CONSUMER_DISCOUNT_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>RECO.CASH</td>
                        <td>{{ $transaction->where('type', App\Transaction::TYPE_SELLER_AGENT_PROVISION_PAYMENT)->first()->present()->amount }}</td>
                    </tr>
                    <tr>
                        <td>Datum</td>
                        <td>{{ $transaction->first()->present()->creationDate }}</td>
                    </tr>
                    <tr>
                        <td>Status</td>
                        <td>
                            @if (App\Transaction::STATUS_ALLOCATED === $transaction->first()->status && App\Coupon::STATUS_PAID === $transaction->first()->coupon->status)
                                <span class="badge badge-pill badge-warning">&nbsp;</span>&nbsp;<span>Einziehbar</span>
                            @elseif (App\Transaction::STATUS_ALLOCATED === $transaction->first()->status && App\Coupon::STATUS_DONE === $transaction->first()->coupon->status)
                                <span class="badge badge-pill badge-primary">&nbsp;</span>&nbsp;<span>Im Banklauf</span>
                            @else
                                {{ $transaction->first()->present()->statusBootstrap }}
                            @endif

                            @if ($transaction->first()->invoice_id)
                                <a class="btn btn-outline-primary btn-round" href="{{ $transaction->first()->getPDFLink() }}" target="_blank"><i class="far fa-file-pdf"></i></a>
                            @endif
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Schließen</button>
            </div>
        </div>
    </div>
</div>