@extends('redesign.layouts.dashboard')

@section('title', 'Transaktionen')

@section('documentTitle', 'Transaktionen')

@section('overlay-style', 'display:block')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if( $transactions->count() )
            <div class="row mb-4">
                @include('redesign.back.seller.transactions.pieces.numbers')
            </div>

            <div class="row mb-4">
                <div class="form-group col-12 inputHolder">
                    <label for="transactionsSearchInput">Suche</label>
                    <div class="input-group">
                        <input type="search" class="form-control" id="transactionsSearchInput" placeholder="Beginne zu suchen">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="button" id="transactionsSearchReset">
                                <i class="fas fa-ban"></i> Zurücksetzen
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row d-none" id="sellerTransactionsTableHolder">
                @include('redesign.back.seller.transactions.pieces.table')
            </div>
        @else
            <div class="pt-5 pb-5 text-center">
                <h2 class="mb-4">Es liegen noch keine Transaktionen vor.</h2>
                <a class="btn btn-primary" href="{{ route('home') }}">
                    <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                </a>
            </div>

            <div class="row" id="sellerTransactionsTableHolder">
                @include('redesign.back.seller.transactions.pieces.table_fake')
            </div>
        @endif
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/dataTables/datatables.min.js') }}"></script>
    <script src="{{ asset('js/plugins/dataTables/dataTables.bootstrap4.min.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('css/plugins/dataTables/dataTables.bootstrap4.css') }}">

    @if( $transactions->count() )

        <script>
            $(document).ready(function() {
                var dt = $('#sellerTransactionsTable').DataTable({
                    order: [],
                    autoWidth: false,
                    dom: '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>' +
                        '<"col-12"t>' +
                        '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>',
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    columns: [
                        null, null, null, null, null, null, null, null, {orderable: false},
                    ],
                });

                $('#transactionsSearchInput').on('change keyup', function () {
                    var s = $(this).val().trim();
                    s = s.replace(/\s/g, '');
                    dt.search(s).draw();
                });

                $('#transactionsSearchReset').on('click', function () {
                    $('#transactionsSearchInput').val('').change();
                });

                $('#sellerTransactionsTableHolder').removeClass('d-none');
                $('#overlay').hide();
            });
        </script>

    @else

        <script>
            $(document).ready(function() {
                var dt = $('#sellerTransactionsTable').DataTable({
                    paging: false,
                    info: false,
                    searching: false,
                    autoWidth: false,
                    dom: 't',
                    order: [[ 0, 'asc' ]],
                    language: {
                        url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                    },
                    columns: [
                        null, null, null, null, null, null, null, null, {orderable: false},
                    ],
                });

                $('#overlay').hide();
            });
        </script>

    @endif
@endsection