@extends('redesign.layouts.dashboard')

@section('title', 'Kunden einladen')

@section('documentTitle', 'Kunden einladen')

@section('document')
    <div class="container" id="dashboardContentHolder">
        <div class="row">
            <div class="col-12 col-md-10 offset-md-1 col-lg-8 offset-lg-2 col-xl-6 offset-xl-3 text-center">
                <h2 class="mb-5">Lade jetzt Deine Empfehler ein</h2>

                @if( !$deals->count() )
                    <div class="alert alert-danger mb-5">
                        <p>Du musst mindestens einen Deal erstellen um Empfehler einladen zu konnen.</p>
                        <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                            <i class="fas fa-plus-circle"></i> Neuen Deal erstellen
                        </a>
                    </div>

                    <div class="alert alert-secondary noselect" style="opacity: 0.5">
                        {{ $links->raw }}
                    </div>

                    @include('redesign.front.user.pieces.referrals.link_mock')
                @else
                    <div class="alert alert-success" id="refLink">
                        {{ $links->raw }}
                    </div>

                    @include('redesign.front.user.pieces.referrals.link')
                @endif
            </div>
        </div>
    </div>
@endsection

@section('scripts-page')
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : {{ config('services.facebook.app_id') }},
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v3.2'
            });
        };

        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
@endsection