@extends('redesign.layouts.dashboard')

@section('title', 'Bewertungen')

@section('documentTitle', 'Bewertungen')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if ($reviewsCount)
            <div class="text-center mb-4">
                @include('redesign.front.pieces.rating', ['id' => 'sellerRating', 'rating' => $reviewsAvg])
                <div id="sellerDashboardReviewsCount">
                    {{ $reviewsCount }} {{ 1 < $reviewsCount ? 'Bewertungen' : 'Bewertung' }} / {{ $reviewsAvg }}
                </div>
            </div>

            <div id="sellerReviewsMarkHolder" class="d-flex justify-content-around flex-wrap">
                @for ($i = 5; $i > 0; $i--)
                    <div class="sellerReviewsMark text-center">
                        @include('redesign.front.pieces.rating', ['classes' => 'sellerReviewsMarkRating', 'rating' => $i])
                        <div class="sellerReviewsMarkFooter">
                            <div class="sellerReviewsMarkCount">{{ $reviewsCounts[$i] }}</div>
                            <div class="sellerReviewsMarkBar">
                                <div class="sellerReviewsMarkBarValue" style="width:{{ ceil(100 * $reviewsCounts[$i] / $reviewsCount) }}%;"></div>
                            </div>
                        </div>
                    </div>
                @endfor
            </div>
        @endif

        @forelse($reviews as $review)
            @include('redesign.front.pieces.review.for_seller', ['review' => $review])
        @empty
            <div class="pt-5 pb-5 text-center">
                <h2 class="mb-4">Noch keine Bewertungen vorhanden.</h2>
                <a class="btn btn-primary" href="{{ route('home') }}">
                    <i class="fas fa-tachometer-alt"></i> Zum Dashboard
                </a>
            </div>
        @endforelse
    </div>
@endsection