<div class="card card-profile shadow p-2 text-center userProfileSection">
    <div class="card-header">Bewertungen</div>
    <div class="card-body">
        @if ($reviewsCount)
            <div class="text-center">
                @include('redesign.front.pieces.rating', ['rating' => $reviewsAvg])
                <span id="sellerRatingAvg">{{ $reviewsAvg }}</span> <span id="sellerRatingCount">/ {{ $reviewsCount }}</span>
            </div>
            <div class="mt-2 text-center">
                @foreach($reviewsCounts as $k => $v)
                    <div>
                        <div class="sellerRatingMarkCount">{{ $v }}</div>
                        @include('redesign.front.pieces.rating', ['rating' => $k, 'classes' => 'dashboard'])
                    </div>
                @endforeach
            </div>
        @else
            <p>Noch keine Bewertungen vorhanden.</p>
        @endif
    </div>
    @if ($reviewsCount)
    <div class="card-footer">
        <a href="{{ route('seller.reviews.index') }}" class="btn btn-success text-white">
            <i class="fas fa-star"></i>
            Alle Bewertungen anschauen
        </a>
    </div>
    @endif
</div>