<div class="card card-profile shadow p-2 text-center @if($user->account->picture) profileSectionFilled @else profileSectionEmpty @endif">
    <div class="card-header">Firmenbild</div>
    <div class="card-body">
        @if (!$user->account->picture)
            <div class="alert alert-info">Laden Sie ein Imagebild hoch um Ihr Unternehmen noch besser in Szene zu setzen.</div>
        @endif

        @if ($errors->has('picture'))
            <p class="text-danger">{{ $errors->first('picture') }}</p>
        @endif

        <div id="sellerPicture" style="background-image:url({{ asset($user->account->picture ?? '/account/portraits/business.png') }})" data-bg="url({{ asset($user->account->picture ?? '/account/portraits/business.png') }})"></div>
    </div>
    <div class="card-footer">
        <div id="sellerPictureChangeBtnsHolder">
            <div class="btn btn-primary" id="sellerPictureChangeBtn">
                @if ($user->account->picture)
                    <span>Ändern</span>
                @else
                    <span>Auswählen</span>
                @endif
            </div>
        </div>
        <div id="sellerPictureUploadBtnsHolder">
            <div class="btn btn-primary" id="sellerPictureUploadBtn">Speichern</div>
            <div class="btn btn-secondary" id="sellerPictureCancelBtn">Abbrechen</div>
        </div>
    </div>
    <form action="{{ route('user.set-picture') }}" method="post" class="d-none" id="sellerPictureForm" enctype="multipart/form-data">
        {{ csrf_field() }}
        <input type="file" name="picture" id="sellerPictureInput" accept="image/*" />
    </form>
</div>