<a name="email"></a>
<div class="card card-profile shadow p-2 text-center userProfileSection @if($user->email_verified) profileSectionFilled @else profileSectionEmpty @endif">
    <div class="card-header">E-Mail (für Anmeldung)</div>
    <div class="card-body">
        <div class="userProfileStatic">
            @if(!$user->email_verified)
                <div class="alert alert-warning">
                    <p>Bitte bestätige Deine E-Mail. Wir haben eine Bestätigungsmail mit einem Link an <strong>{{ $user->email_temp ? $user->email_temp : $user->email }}</strong> gesendet.</p>
                    @if($user->email_temp)
                        <p>Aktuelle login E-Mail: <strong>{{ $user->email }}</strong></p>
                    @endif
                    <p>Sollte die E-Mail nicht angekommen sein bitte <a href="#" class="alert-link" id="emailVerificationSend">hier klicken</a>.</p>
                </div>
            @endif
            <form>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">E-Mail</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="email" value="{{ $user->email_temp ? $user->email_temp : $user->email }}">
                    </div>
                </div>
            </form>
        </div>
        <div class="userProfileEditable">
            <form action="{{ route('api.change-email') }}" data-reload="true">
                <div class="alert alert-danger">
                    Nach Änderung gilt die neue E-Mail für die Anmeldung.
                </div>
                <div class="form-group row">
                    <label for="userProfileEmail" class="col-4 col-form-label text-right">E-Mail</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileEmail" name="email" placeholder="E-Mail" value="{{ $user->email_temp ? $user->email_temp : $user->email }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="email"></p>
                </div>
            </form>
        </div>
    </div>
    <div class="card-footer">
        <div class="userProfileStatic">
            <div class="btn btn-primary userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</div>
        </div>
        <div class="userProfileEditable">
            <div class="btn btn-primary userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</div>
            <div class="btn btn-secondary userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</div>
        </div>
    </div>
    <div class="userProfileOverlay">
        <span><i class="fas fa-spinner animate-spin"></i></span>
    </div>
</div>