<div class="card card-profile shadow p-2 text-center userProfileSection profileSectionRequired  @if($user->account->company) profileSectionFilled @else profileSectionEmpty @endif">
    <div class="card-header">Unternehmensdaten</div>
    <div class="card-body">
        <div class="userProfileStatic">
            <form>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Firmenname</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="company" value="{{ $user->account->company }}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Beschreibung</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="description" value="{{ $user->account->description }}">
                    </div>
                </div>
            </form>
        </div>
        <div class="userProfileEditable">
            <form action="{{ route('api.change-company') }}">
                <div class="form-group row">
                    <label for="userProfileCompany" class="col-4 col-form-label text-right">Firmenname</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileCompany" name="company" placeholder="Firmenname" value="{{ $user->account->company }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="company"></p>
                </div>
                <div class="form-group row">
                    <label for="userProfileDescr" class="col-4 col-form-label text-right">Beschreibung</label>
                    <div class="col-8">
                        <textarea class="form-control userProfileInput" id="userProfileDescr" name="description" placeholder="Firmenname">{{ $user->account->description }}</textarea>
                    </div>
                    <p class="userProfileError text-danger" data-input="description"></p>
                </div>
            </form>
        </div>
    </div>
    <div class="card-footer">
        <div class="userProfileStatic">
            <div class="btn btn-primary userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</div>
        </div>
        <div class="userProfileEditable">
            <div class="btn btn-primary userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</div>
            <div class="btn btn-secondary userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</div>
        </div>
    </div>
    <div class="userProfileOverlay">
        <span><i class="fas fa-spinner animate-spin"></i></span>
    </div>
</div>