<a name="payment"></a>
<div class="card card-profile shadow p-2 text-center userProfileSection @if($user->account->iban && $user->account->iban_owner) profileSectionFilled @else profileSectionEmpty @endif">
    <div class="card-header">Bankverbindung</div>
    <div class="card-body">
        <div class="userProfileStatic">
            <form>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">IBAN</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="iban" value="{{ $user->account->iban }}">
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Kontoinhaber</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="iban_owner" value="{{ $user->account->iban_owner }}">
                    </div>
                </div>
            </form>
        </div>
        <div class="userProfileEditable">
            <form action="{{ route('api.change-banking') }}">
                <div class="form-group row">
                    <label for="userProfileIBAN" class="col-4 col-form-label text-right">IBAN</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileIBAN" name="iban" placeholder="IBAN" value="{{ $user->account->iban }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="iban"></p>
                </div>
                <div class="form-group row">
                    <label for="userProfileIBANOwner" class="col-4 col-form-label text-right">Kontoinhaber</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileIBANOwner" name="iban_owner" placeholder="Kontoinhaber" value="{{ $user->account->iban_owner }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="iban_owner"></p>
                </div>
            </form>
        </div>
    </div>
    <div class="card-footer">
        <div class="userProfileStatic">
            <div class="btn btn-primary userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</div>
        </div>
        <div class="userProfileEditable">
            <div class="btn btn-primary userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</div>
            <div class="btn btn-secondary userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</div>
        </div>
    </div>
    <div class="userProfileOverlay">
        <span><i class="fas fa-spinner animate-spin"></i></span>
    </div>
</div>