<div class="card card-profile shadow p-2 text-center userProfileSection @if($user->alias != $user->id) profileSectionFilled @else profileSectionEmpty @endif">
    <div class="card-header">Alias</div>
    <div class="card-body">
        <div class="userProfileStatic">
            <form>
                <div class="form-group row">
                    <label class="col-4 col-form-label text-right">Alias</label>
                    <div class="col-8">
                        <input type="text" readonly class="form-control-plaintext" data-binded="alias" value="{{ $user->alias }}">
                    </div>
                </div>
            </form>
        </div>
        <div class="userProfileEditable">
            <form action="{{ route('api.change-alias') }}" data-reload="true">
                <div class="form-group row">
                    <label for="userProfileAlias" class="col-4 col-form-label text-right">Alias</label>
                    <div class="col-8">
                        <input type="text" class="form-control userProfileInput" id="userProfileAlias" name="alias" placeholder="Alias" value="{{ $user->alias }}">
                    </div>
                    <p class="userProfileError text-danger" data-input="alias"></p>
                </div>
            </form>
        </div>
    </div>
    <div class="card-footer">
        <div class="userProfileStatic">
            <div class="btn btn-primary userProfileEditBtn" id="userProfilePasswordChangeBtn">Ändern</div>
        </div>
        <div class="userProfileEditable">
            <div class="btn btn-primary userProfileSaveBtn" id="userProfilePasswordSaveBtn">Speichern</div>
            <div class="btn btn-secondary userProfileCancelBtn" id="userProfilePasswordCancelBtn">Abbrechen</div>
        </div>
    </div>
    <div class="userProfileOverlay">
        <span><i class="fas fa-spinner animate-spin"></i></span>
    </div>
</div>