@extends('redesign.layouts.dashboard')

@section('title', 'Profil')

@section('documentTitle', 'Profil')

@section('document')
    <div class="container @if(session('warning')) highlightRequired @endif" id="dashboardContentHolder">
        <div class="row">
            @if(session('warning'))
                <div class="col-12">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('warning') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            @endif

            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.profile.pieces.userpic', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.personal', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.company', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.alias', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.email', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.reviews', ['user' => $user])
            </div>
            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.profile.pieces.logo', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.picture', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.contacts', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.places', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.banking', ['user' => $user])
                @include('redesign.back.seller.profile.pieces.password', ['user' => $user])
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.profile.pieces.preview', ['user' => $user])
            </div>
            <div class="col-12 col-xl-6">
                @include('redesign.back.seller.profile.pieces.invite', ['user' => $user])
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                @include('redesign.back.seller.profile.pieces.newsletter', ['user' => $user])
            </div>
        </div>
    </div>
@endsection

@section('scripts-page')
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : {{ config('services.facebook.app_id') }},
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v3.2'
            });
        };

        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "https://connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
    <script>
        $(document).ready(function () {

        });
    </script>
@endsection