@extends('redesign.layouts.dashboard')

@section('title', 'Standort erstellen')

@section('documentTitle', 'Standort erstellen')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if(session('warning'))
            <div class="col-12">
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('warning') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            </div>
        @endif

        <form action="{{ route('seller.place.create') }}" method="post">
            {{ csrf_field() }}
            <div class="row">
                <div class="col-lg-6 offset-lg-0 col-xl-5 offset-xl-1 col-xxl-4 offset-xxl-2">
                    @include('redesign.back.seller.places.pieces.form.contacts')
                </div>
                <div class="col-lg-6 col-xl-5 col-xxl-4">
                    @include('redesign.back.seller.places.pieces.form.worktimes')
                </div>
            </div>
            <div class="row">
                <div class="col-12 text-center">
                    <button class="btn btn-primary btn-lg" type="submit">
                        <i class="fas fa-save"></i>
                        Erstellen
                    </button>
                    <a class="btn btn-secondary" href="{{ route('seller.places.index') }}">
                        <i class="fas fa-ban"></i>
                        Abbrechen
                    </a>
                </div>
            </div>
        </form>
    </div>
@endsection
