<tr>
    <td class="align-middle d-xl-none address-cell">
        {{ $place->present()->address }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->zip }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->city }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->street }}
    </td>
    <td class="align-middle d-none d-xl-table-cell">
        {{ $place->housenumber }}
    </td>
    <td class="align-middle d-none d-lg-table-cell">
        {{ $place->phone }}
        @if($place->email)
            <br>{{ $place->email }}
        @endif
    </td>
    <td class="align-middle text-monospace d-none d-lg-table-cell">
        @if($place->wt_mon)
            <span class="badge badge-secondary " data-toggle="tooltip" data-title="{{ $place->wt_mon }}">Mo</span>
        @endif

        @if($place->wt_tue)
            <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_tue }}">Di</span>
        @endif

        @if($place->wt_wed)
            <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_wed }}">Mi</span>
        @endif

        @if($place->wt_thu)
        <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_thu }}">Do</span>
        @endif

        @if($place->wt_fri)
            <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_fri }}">Fr</span>
        @endif

        @if($place->wt_sat)
            <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_sat }}">Sa</span>
        @endif

        @if($place->wt_sun)
            <span class="badge badge-secondary" data-toggle="tooltip" data-title="{{ $place->wt_sun }}">So</span>
        @endif
    </td>
    <td class="align-middle d-none d-md-table-cell">
        {{ $place->present()->status }}
    </td>
    <td class="align-middle text-right">
        <div class="d-inline-block d-lg-none">{{ $place->present()->statusBadge }}</div>

        @if(App\Place::STATUS_ACTIVE === $place->status)
            <a class="btn btn-outline-danger" href="{{ route('seller.place.deactivate', $place) }}" data-toggle="tooltip" data-title="Deaktivieren">
                <i class="fas fa-toggle-off"></i>
            </a>
        @else
            <a class="btn btn-outline-success" href="{{ route('seller.place.activate', $place) }}" data-toggle="tooltip" data-title="Aktivieren">
                <i class="fas fa-toggle-on"></i>
            </a>
        @endif

        <a class="btn btn-primary" href="{{ route('seller.place.edit', $place) }}" data-toggle="tooltip" data-title="Bearbeiten">
            <i class="fas fa-pencil-alt"></i>
        </a>

        <a class="btn btn-danger text-white placeDeleteBtn" href="{{ route('seller.place.delete', $place) }}" data-toggle="tooltip" data-title="Löschen">
            <i class="fas fa-trash"></i>
        </a>
    </td>
</tr>