@extends('redesign.layouts.dashboard')

@section('title', 'Standorte')

@section('documentTitle', 'Standorte')

@section('overlay-style', 'display:block')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if( $places->count() )
            <div class="row mb-4">
                <div class="col-12">
                    <a class="btn btn-primary" href="{{ route('seller.place.store') }}">
                        <i class="fas fa-plus-circle"></i> Neuen Standort erstellen
                    </a>
                </div>
            </div>

            <div class="row mb-4">
                <div class="form-group col-12 inputHolder">
                    <label for="placeSearchInput">Standort suche</label>
                    <div class="input-group">
                        <input type="search" class="form-control" id="placeSearchInput" placeholder="Beginne zu suchen">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="button" id="placeSearchReset">
                                <i class="fas fa-ban"></i> Zurücksetzen
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row d-none" id="sellerPlacesTableHolder">
                @include('redesign.back.seller.places.pieces.table')
            </div>

            <form action="" method="post" style="display: none" id="placeDeleteForm">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
            </form>
        @else
            <div class="pt-5 pb-5 text-center">
                <h2 class="mb-4">Noch keine Standorte.</h2>
                <a class="btn btn-primary" href="{{ route('seller.place.store') }}">
                    <i class="fas fa-plus-circle"></i> Neuen Standort erstellen
                </a>
            </div>
        @endif
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/dataTables/datatables.min.js') }}"></script>
    <script src="{{ asset('js/plugins/dataTables/dataTables.bootstrap4.min.js') }}"></script>
    <link rel="stylesheet" href="{{ asset('css/plugins/dataTables/dataTables.bootstrap4.css') }}">
    <script>
        $(document).ready(function() {
            var dt = $('#sellerPlacesTable').DataTable({
                order: [],
                autoWidth: false,
                dom: '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>' +
                    '<"col-12"t>' +
                    '<"col-12"<"row"<"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-left"l><"col-12 col-sm-6 col-lg-3 col-xl-4 text-center text-sm-right text-lg-center"i><"col-12 col-lg-6 col-xl-4 text-right"p>>>',
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'Alle']],
                language: {
                    url: '{{ asset('js/plugins/dataTables/i18n/German.json') }}',
                }
            });

            $('#placeSearchInput').on('change keyup', function () {
                var s = $(this).val().trim();
                s = s.replace(/\s/g, '');
                dt.search(s).draw();
            });

            $('#placeSearchReset').on('click', function () {
                $('#placeSearchInput').val('').change();
            });

            $('.placeDeleteBtn').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                swal({
                    title: 'Bist du sicher?',
                    text: 'Aktion ist nicht kündbar',
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Ja',
                    cancelButtonText: 'Nein',
                    focusConfirm: false,
                    focusCancel: true,
                    heightAuto: false,
                }).then((result) => {
                    if (result.value) {
                        $('#placeDeleteForm')
                            .attr('action', $(this).attr('href'))
                            .submit();
                    }
                });
            });

            $('#sellerPlacesTableHolder').removeClass('d-none');
            $('#overlay').hide();
        });
    </script>
@endsection