@extends('redesign.layouts.dashboard')

@section('title', 'Deals')

@section('documentTitle', 'Deals')

@section('document')
    <div class="container" id="dashboardContentHolder">
        @if( $deals->count() )
            <div class="row mb-4">
                <div class="col-12">
                    <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                        <i class="fas fa-plus-circle"></i> Neuen Deal erstellen
                    </a>
                </div>
            </div>

            <div class="row mb-4">
                <div class="form-group col-12 inputHolder">
                    <label for="dcDealSearchInput">Deal suche</label>
                    <div class="input-group">
                        <input type="search" class="form-control" id="dcDealSearchInput" placeholder="Beginne zu suchen" data-search-scope="#sellerDealsTable tbody tr" data-search-holder="#sellerDealsTable" data-search-nothing="#sellerDealsNothing">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="button" id="dcDealSearchReset" data-search-reset="#dcDealSearchInput">
                                <i class="fas fa-ban"></i> Zurücksetzen
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                @include('redesign.back.seller.deals.pieces.table')
            </div>
        @else
            <div class="pt-5 pb-5 text-center">
                <h2 class="mb-4">Noch keine Deals.</h2>
                <a class="btn btn-primary" href="{{ route('seller.deal.create') }}">
                    <i class="fas fa-plus-circle"></i> Neuen Deal erstellen
                </a>
            </div>

            <div class="row">
                @include('redesign.back.seller.deals.pieces.table_fake')
            </div>
        @endif
    </div>
@endsection

@section('scripts-page')
    <script src="{{ asset('js/plugins/dataTables/datatables.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#sellerDealsTable').DataTable({
                paging: false,
                info: false,
                searching: false,
                autoWidth: false,
                dom: 't',
                order: [[ 0, 'asc' ]],
                columns: [
                    null, null, null, null, null, null, null, {orderable: false},
                ],
            });
        });
    </script>
@endsection